% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{selection.lag.lead}
\alias{selection.lag.lead}
\title{The lag-lead model selection for MARX function}
\usage{
selection.lag.lead(y, x, p_pseudo)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p_pseudo}{Number of autoregressive terms to be included in the pseudo-causal model.}
}
\value{
\item{p.C}{The number of lags selected.}

\item{p.NC}{The number of leads selected.}

\item{loglikelihood}{The value of the loglikelihood for all models with p = r + s.}
}
\description{
This function allows you to determine the MARX model (for p = r + s) that maximizes the t-log-likelihood.
}
\examples{
data <- sim.marx(c('t',3,1), c('t',3,1),100,0.5,0.4,0.3)
selection.lag.lead(data$y,data$x,2)
}
\author{
Sean Telg
}
\keyword{causal-noncausal}
\keyword{selection}
