% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_06_DE_5_1_GO.R
\name{BioPathways}
\alias{BioPathways}
\title{Gene Ontology Analysis}
\usage{
BioPathways(
  MarvelObject,
  de.p.val.adj = NULL,
  n.top = NULL,
  min.gene.set.size = 10,
  method.adjust,
  remove.ribo = FALSE,
  annotate = FALSE
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{de.p.val.adj}{Numeric value. Adjusted p-value below which the splicing events are considered differentially spliced and their corresponding genes are included for gene ontology analysis. If this argument is specified, then \code{n.top} must not be specified.}

\item{n.top}{Numeric value. Alternative to \code{de.p.val.adj}. Indicate the top n splicing events with the smallest adjusted p-values are differentially spliced and their corresponding genes are included for gene ontology analysis. If this argument is specified, then \code{de.p.val.adj} must not be specified.}

\item{min.gene.set.size}{Numeric value. Only evaluate enrichment of gene sets if the gene set is equal or bigger than this value. Default value is 10.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}

\item{remove.ribo}{Logical. If set to \code{TRUE}, all ribosomal genes (genes with prefix RPS and RPL) meeting \code{de.p.val.adj} or \code{n.top} criteria will be removed prior to gene ontology analysis. This can prevent ribosomal genes from obscuring enriched gene sets that are not related to ribosomal genes.}

\item{annotate}{Logical. If set to \code{TRUE}, the genes differentially spliced that are found in each gene set are returned.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to a new slot named \code{MarvelObject$DE$BioPathways} containing the gene sets significantly enriched among differentially spliced genes.
}
\description{
\code{BioPathways} performs gene ontology analysis on genes that are differentially spliced.
}
\details{
This function performs gene ontology analysis on genes that are differentially spliced to identify significantly regulated gene sets (biological pathways).
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- BioPathways(MarvelObject=marvel,
                      n.top=5,
                      method.adjust="fdr"
                      )
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
