## Copyright 2013 Sebastian Gibb
## <mail@sebastiangibb.de>
##
## This file is part of MALDIquant for R and related languages.
##
## MALDIquant is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## MALDIquant is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with MALDIquant. If not, see <http://www.gnu.org/licenses/>

## deprecated since MALDIquant 1.7.4

## MassPeaks
setMethod(f="totalIonCurrent",
          signature=signature(object="MassPeaks"),
          definition=function(object) {

  .deprecatedFunction("1.7.4")
  return(as.double(sum(as.double(object@intensity), na.rm=TRUE)))
})

## deprecated since MALDIquant 1.7.6

## calibrate
##  calibrate intensityMatrix
##
## params:
##  x: a numeric matrix (generated by MALDIquant::intensityMatrix
##      rows: samples; cols: features
##
## returns:
##  a calibrated numeric matrix
##
if (is.null(getGeneric("calibrate"))) {
  setGeneric("calibrate", function(x, ...) standardGeneric("calibrate"))
}
setMethod(f="calibrate",
          signature=signature(x="matrix"),
          definition=function(x, ...) {

  .deprecatedFunction("1.7.6", new="calibrateIntensity")

  ## create "reference" spectrum/peak list
  r <- apply(x, 2, median, na.rm=TRUE)

  ## estimate scale factor
  s <- apply(x, 1, function(y)median(y/r, na.rm=TRUE))

  ## scale matrix
  x <- apply(x, 2, function(y)y/s)

  ## add scale attribute
  attr(x, "scale") <- s

  return(x)
})

if (is.null(getGeneric("standardizeTotalIonCurrent"))) {
  setGeneric("standardizeTotalIonCurrent", function(object, value=1)
               standardGeneric("standardizeTotalIonCurrent"))
}
setMethod(f="standardizeTotalIonCurrent",
          signature=signature(object="list"),
          definition=function(object, value=1) {

  .deprecatedFunction("1.7.6", new="calibrateIntensity")

  ## test arguments
  .stopIfNotIsMassObjectList(object)

  return(lapply(object, "totalIonCurrent<-", value))
})

if (is.null(getGeneric("totalIonCurrent<-"))) {
  setGeneric("totalIonCurrent<-",
             function(object, value) standardGeneric("totalIonCurrent<-"))
}
## AbstractMassObject
setReplaceMethod(f="totalIonCurrent",
                 signature=signature(object="AbstractMassObject",
                                     value="numeric"),
                definition=function(object, value) {

  .deprecatedFunction("1.7.6", new="calibrateIntensity")

  if (length(value) != 1) {
    stop("Length of ", sQuote("value"), " has to be one.")
  }

  tic <- totalIonCurrent(object)

  if (tic) {
    return(.transformIntensity(object, fun=function(x)x*value/tic))
  } else {
    warning("Total Ion Current is zero! Is spectrum empty?")
    return(object)
  }
})

## deprecated since MALDIquant 1.7.10

if (is.null(getGeneric("ltrim"))) {
  setGeneric("ltrim", function(object, minMass) standardGeneric("ltrim"))
}

## AbstractMassObject
setMethod("ltrim",
          signature=signature(object="AbstractMassObject", minMass="numeric"),
          definition=function(object, minMass) {
  .deprecatedFunction("1.7.10", new="trim")
  return(trim(object, range=c(minMass, Inf)))
})

## list
setMethod("ltrim",
          signature=signature(object="list", minMass="numeric"),
          definition=function(object, minMass) {
  return(lapply(object, ltrim, minMass=minMass))
})

if (is.null(getGeneric("rtrim"))) {
  setGeneric("rtrim", function(object, maxMass) standardGeneric("rtrim"))
}

## AbstractMassObject
setMethod("rtrim",
          signature=signature(object="AbstractMassObject", maxMass="numeric"),
          definition=function(object, maxMass) {
  .deprecatedFunction("1.7.10", new="trim")
  return(trim(object, range=c(-Inf, maxMass)))
})

## list
setMethod("rtrim",
          signature=signature(object="list", maxMass="numeric"),
          definition=function(object, maxMass) {
  return(lapply(object, rtrim, maxMass=maxMass))
})

## deprecated since MALDIquant 1.7.12
mergeMassSpectra <- function(l, labels, fun=mean, ...) {

  .deprecatedFunction("1.7.12", new="averageMassSpectra")

  ## test parameters
  .stopIfNotIsMassSpectrumList(l)

  return(.doByLabels(l=l, labels=labels, FUN=.mergeMassSpectra, fun=fun, ...))
}

.mergeMassSpectra <- function(l, fun=mean, na.rm=TRUE, ...) {

  ## very simple score to find the "best" spectrum
  simpleScore <- function(x) {return(max(x@intensity)/mean(x@intensity))}

  ## merge metaData
  metaData <- .mergeMetaData(lapply(l, function(x)x@metaData))

  ## look for empty MassSpectrum objects
  emptyIdx <- findEmptyMassObjects(l)
  nEmpty <- length(emptyIdx)
  n <- length(l)

  if (nEmpty) {
    l <- l[-emptyIdx]
  }

  ## calculate spectra scores
  maxScore <- which.max(vapply(l, simpleScore, double(1)))

  if (length(maxScore)) {
    ## use highest scored spectrum as reference
    mass <- l[[maxScore]]@mass
  } else {
    ## or nothing if all spectra are empty
    mass <- NA
  }

  ## interpolate not existing masses
  approxSpectra <- lapply(l, approxfun)

  ## get intensities
  if (nEmpty) {
    intensityList <- vector(mode="list", length=n)
    intensityList[emptyIdx] <- rep(NA, nEmpty)
    intensityList[-emptyIdx] <- lapply(approxSpectra, function(x)x(mass))
  } else {
    intensityList <- lapply(approxSpectra, function(x)x(mass))
  }

  ## create a matrix which could merged
  m <- do.call(rbind, intensityList)

  ## merge intensities
  intensity <- .merge(m, fun=fun, na.rm=na.rm, ...)

  ## create an empty spectrum if all intensities are NaN
  if (is.nan(intensity[1])) {
    intensity <- double()
    mass <- double()
  }

  return(createMassSpectrum(mass=mass, intensity=intensity, metaData=metaData))
}

.merge <- function(m, fun, na.rm=TRUE, ...) {

  fun <- match.fun(fun)

  if (identical(fun, mean)) {
    m <- colMeans(m, na.rm=na.rm)
  } else if (identical(fun, sum)) {
    m <- colSums(m, na.rm=na.rm)
  } else {
    ## mean, median, sum etc. have their own na.rm argument but maybe some other
    ## curious merge function lacks na.rm
    ## [would cause the error: unused argument(s) (na.rm = T)]
    ## thats why we have to remove NA's for our own
    if (na.rm) {
      m <- apply(X=m, MARGIN=2, FUN=function(x){
        return(fun(x[!is.na(x)], ...))
      })
    } else {
      m <- apply(X=m, MARGIN=2, FUN=fun, ...)
    }
  }
  return(m)
}

.mergeMassPeaksDeprecated <- function(l, fun=mean, na.rm=TRUE, ...) {

  ## create a matrix which could merged
  m <- intensityMatrix(l)

  mass <- as.double(colnames(m))

  ## avoid named intensity/snr slot
  colnames(m) <- NULL

  ## merge intensities
  intensity <- .merge(m, fun=fun, na.rm=na.rm, ...)

  ## merge snr
  for (i in seq(along=l)) {
    m[i, !is.na(m[i, ]) ] <- l[[i]]@snr
  }
  snr <- .merge(m, fun=fun, ...)

  ## merge metaData
  metaData <- .mergeMetaData(lapply(l, function(x)x@metaData))

  return(createMassPeaks(mass=mass, intensity=intensity, snr=snr,
                         metaData=metaData))
}

movingAverage <- function(y, halfWindowSize=2L) {
  .deprecatedFunction("1.7.12", new="smoothIntensity")
  return(.movingAverage(y, halfWindowSize))
}

savitzkyGolay <- function(y, halfWindowSize=10L, polynomialOrder=3L) {
  .deprecatedFunction("1.7.12", new="smoothIntensity")
  return(.savitzkyGolay(y, halfWindowSize, polynomialOrder))
}

## deprecated since MALDIquant 1.7.13
isMassObject <- function(x) {
  .deprecatedFunction("1.7.13")
  return(.isMassObject(x))
}

isMassObjectList <- function(x) {
  .deprecatedFunction("1.7.13")
  return(.isMassObjectList(x))
}

## deprecated since MALDIquant 1.8.4
## intensityMatrix for MassSpectrum objects
## TODO: remove corresponding code in intensityMatrix
.intensityMatrixDeprecated <- function(l) {
  mass <- sort(x=.unlist(lapply(l, function(x)x@mass)), method="quick")
  uniqueMass <- unique(mass)

  ## build matrix
  m <- do.call(rbind, lapply(l, function(x) {
    return(x@intensity[match(x=uniqueMass, table=x@mass, nomatch=NA)])}))

  ## set column names
  dimnames(m) <- list(NULL, c(uniqueMass))

  return(m)
}
