% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maaper.R
\name{maaper}
\alias{maaper}
\title{Model-based analysis of alternative polyadenylation using 3’ end-linked reads}
\usage{
maaper(
  gtf,
  pas_annotation,
  output_dir,
  bam_c1,
  bam_c2,
  read_len,
  ncores = 1,
  num_pas_thre = 25,
  frac_pas_thre = 0.05,
  dist_thre = 600,
  num_thre = 50,
  run = "all",
  subset = NULL,
  region = "all",
  gtf_rds = NULL,
  verbose = FALSE,
  paired = FALSE,
  bed = FALSE
)
}
\arguments{
\item{gtf}{A character specifying the full path of the GTF file (reference genome);}

\item{pas_annotation}{A list containing the pas annotation. MAAPER provides processed annotation
information from PolyA_DB v3 on its Github page.}

\item{output_dir}{A character specifying the full path of the output directory,
which is used to store all intermdediate and final outputs.}

\item{bam_c1}{A character vector specifying the full paths to the bam files for
condition 1 (control). The length of the vector equals the number of samples.}

\item{bam_c2}{A character vector specifying the full paths to the bam files for
condition 2 (experiment). The length of the vector equals the number of samples.}

\item{read_len}{An integer specifying the read length.}

\item{ncores}{An integer specifying the number of cores used in parallel computation.}

\item{num_pas_thre}{An integer specifying the threhold on PAS's read number. Defaults to 25.}

\item{frac_pas_thre}{A numeric specifying the threshold on PAS's fraction. Defaults to 0.05.}

\item{dist_thre}{An integer specifying the threshold on fragment length. Defaults to 600.}

\item{num_thre}{An integer specifying the threhold on gene's read number. Defaults to 50.}

\item{run}{"all" (default) or "skip-train". For test and debug only.}

\item{subset}{A character vector specifying genes' Ensembl IDs if only a subset of genes need to be analyzed.
Check the \code{pas_annotation} files for ID formats.}

\item{region}{"all" (default). For test and debug only.}

\item{gtf_rds}{NULL (default). For test and debug only.}

\item{verbose}{FALSE (default). For test and debug only.}

\item{paired}{A boolean indicating whether to perform paired test instead of unpaired test (defaults to FALSE).}

\item{bed}{Aboolean indicating whether bedGraph files should be output for visualization in genome browser.}
}
\value{
\code{maaper} saves two text files, gene.txt and pas.txt, to \code{out_dir}.
pas.txt contains the gene names, predicted PASs, and their corresponding fractions in the two conditions.
gene.txt contains the genes' PAS number, p values, RED, RLDu, and RLDi scores.
}
\description{
Model-based analysis of alternative polyadenylation using 3’ end-linked reads
}
\examples{
\dontrun{
# data used in this example can be found on the package's Github page
pas_annotation = readRDS("./mouse.PAS.mm9.rds")
gtf = "./gencode.mm9.chr19.gtf"
bam_c1 = "./NT_chr19_example.bam"
bam_c2 = "./AS_4h_chr19_example.bam"
maaper(gtf, pas_annotation, output_dir = "./",
       bam_c1, bam_c2, read_len = 76, ncores = 1)
}
}
\author{
Wei Vivian Li, \email{vivian.li@rutgers.edu}
}
