% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_RLum2Risoe.BINfileData.R
\name{convert_RLum2Risoe.BINfileData}
\alias{convert_RLum2Risoe.BINfileData}
\title{Converts RLum.Analysis-objects and RLum.Data.Curve-objects to RLum2Risoe.BINfileData-objects}
\usage{
convert_RLum2Risoe.BINfileData(object, keep.position.number = FALSE)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} or \linkS4class{RLum.Data.Curve} (\strong{required}): input object to
be converted}

\item{keep.position.number}{\link{logical} (with default): keeps the original position number or re-calculate
the numbers to avoid doubling}
}
\value{
The function returns a \linkS4class{Risoe.BINfileData} object.
}
\description{
The functions converts \linkS4class{RLum.Analysis} and \linkS4class{RLum.Data.Curve} objects and a \link{list} of those
to \linkS4class{Risoe.BINfileData} objects. The funtion intends to provide a minimum of compatiblility
between both formats. The created \linkS4class{RLum.Analysis} object can be later exported to a
BIN-file using the function \link{write_R2BIN}.
}
\note{
The conversion can be never perfect. The \code{RLum} objects may contain information which are
not part of the \linkS4class{Risoe.BINfileData} definition.
}
\section{Function version}{
 0.1.3
}

\examples{

##simple conversion using the example dataset
data(ExampleData.RLum.Analysis, envir = environment())
convert_RLum2Risoe.BINfileData(IRSAR.RF.Data)

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve}, \link{write_R2BIN}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2020. convert_RLum2Risoe.BINfileData(): Converts RLum.Analysis-objects and RLum.Data.Curve-objects to RLum2Risoe.BINfileData-objects. Function version 0.1.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Riedesel, S., Autzen, M., 2020. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.8. https://r-luminescence.org
}

\keyword{IO}
