% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gSGC_feldspar.R
\name{calc_gSGC_feldspar}
\alias{calc_gSGC_feldspar}
\title{Calculate Global Standardised Growth Curve (gSGC) for Feldspar MET-pIRIR}
\usage{
calc_gSGC_feldspar(
  data,
  gSGC.type = "50LxTx",
  gSGC.parameters,
  n.MC = 100,
  plot = FALSE
)
}
\arguments{
\item{data}{\link{data.frame} (\strong{required}): data frame with five columns per sample
\code{c("LnTn", "LnTn.error", "Lr1Tr1", "Lr1Tr1.error","Dr1")}}

\item{gSGC.type}{\link{character} (\emph{with default}): growth curve type to be selected
according to Table 3 in Li et al. (2015). Allowed options are
\code{"50LxTx"}, \code{"50Lx"}, \code{"50Tx"}, \code{"100LxTx"}, \code{"100Lx"}, \code{"100Tx"}, \code{"150LxTx"},
\code{"150Lx"}, \code{"150Tx"}, \code{"200LxTx"}, \code{"200Lx"}, \code{"200Tx"}, \code{"250LxTx"}, \code{"250Lx"},
\code{"250Tx"}}

\item{gSGC.parameters}{\link{data.frame} (\emph{optional}): an own parameter set for the
gSGC with the following columns \code{y1}, \code{y1_err}, \code{D1}
\code{D1_err}, \code{y2}, \code{y2_err}, \code{y0}, \code{y0_err}.}

\item{n.MC}{\link{numeric} (\emph{with default}): number of Monte-Carlo runs for the
error calculation}

\item{plot}{\link{logical} (\emph{with default}): enables/disables the control plot output}
}
\value{
Returns an S4 object of type \linkS4class{RLum.Results}.

\strong{\verb{@data}}\cr
\verb{$ df} (\link{data.frame}) \cr
\code{.. $DE} the calculated equivalent dose\cr
\code{.. $DE.ERROR} error on the equivalent dose, which is the standard deviation of the MC runs\cr
\code{.. $HPD95_LOWER} lower boundary of the highest probability density (95\%)\cr
\code{.. $HPD95_UPPER} upper boundary of the highest probability density (95\%)\cr
\verb{$ m.MC} (\link{list}) numeric vector with results from the MC runs.\cr

\strong{\verb{@info}}\cr
`$ call`` (\link{call}) the original function call
}
\description{
Implementation of the gSGC approach for feldspar MET-pIRIR by Li et al. (2015)
}
\details{
##TODO
}
\section{Function version}{
 0.1.0
}

\examples{

##test on a generated random sample
n_samples <- 10
data <- data.frame(
  LnTn = rnorm(n=n_samples, mean=1.0, sd=0.02),
  LnTn.error = rnorm(n=n_samples, mean=0.05, sd=0.002),
  Lr1Tr1 = rnorm(n=n_samples, mean=1.0, sd=0.02),
  Lr1Tr1.error = rnorm(n=n_samples, mean=0.05, sd=0.002),
  Dr1 = rep(100,n_samples))

results <- calc_gSGC_feldspar(
  data = data, gSGC.type = "50LxTx",
  plot = FALSE)

plot_AbanicoPlot(results)

} 

\section{How to cite}{
Gray, H.J., Kreutzer, S., 2023. calc_gSGC_feldspar(): Calculate Global Standardised Growth Curve (gSGC) for Feldspar MET-pIRIR. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.21. https://CRAN.R-project.org/package=Luminescence
}

\references{
Li, B., Roberts, R.G., Jacobs, Z., Li, S.-H., Guo, Y.-J., 2015.
Construction of a “global standardised growth curve” (gSGC) for infrared
stimulated luminescence dating of K-feldspar 27, 119–130. \doi{10.1016/j.quageo.2015.02.010}
}
\seealso{
\linkS4class{RLum.Results}, \link{get_RLum}, \link{uniroot}, \link{calc_gSGC}
}
\author{
Harrison Gray, USGS (United States),
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{datagen}
