% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_FastRatio.R
\name{calc_FastRatio}
\alias{calc_FastRatio}
\title{Calculate the Fast Ratio for CW-OSL curves}
\usage{
calc_FastRatio(
  object,
  stimulation.power = 30.6,
  wavelength = 470,
  sigmaF = 2.6e-17,
  sigmaM = 4.28e-18,
  Ch_L1 = 1,
  Ch_L2 = NULL,
  Ch_L3 = NULL,
  x = 1,
  x2 = 0.1,
  dead.channels = c(0, 0),
  fitCW.sigma = FALSE,
  fitCW.curve = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve} or \link{data.frame} (\strong{required}):
x, y data of measured values (time and counts).}

\item{stimulation.power}{\link{numeric} (\emph{with default}):
Stimulation power in mW/cm^2}

\item{wavelength}{\link{numeric} (\emph{with default}):
Stimulation wavelength in nm}

\item{sigmaF}{\link{numeric} (\emph{with default}):
Photoionisation cross-section (cm^2) of the fast component.
Default value after Durcan & Duller (2011).}

\item{sigmaM}{\link{numeric} (\emph{with default}):
Photoionisation cross-section (cm^2) of the medium component.
Default value after Durcan & Duller (2011).}

\item{Ch_L1}{\link{numeric} (\emph{with default}):
An integer specifying the channel for L1.}

\item{Ch_L2}{\link{numeric} (\emph{optional}):
An integer specifying the channel for L2.}

\item{Ch_L3}{\link{numeric} (\emph{optional}):
A vector of length 2 with integer values specifying the start and end channels for L3
(e.g., \code{c(40, 50)}).}

\item{x}{\link{numeric} (\emph{with default}):
\\% of signal remaining from the fast component.
Used to define the location of L2 and L3 (start).}

\item{x2}{\link{numeric} (\emph{with default}):
\\% of signal remaining from the medium component.
Used to define the location of L3 (end).}

\item{dead.channels}{\link{numeric} (\emph{with default}):
Vector of length 2 in the form of \code{c(x, y)}.
Channels that do not contain OSL data, i.e. at the start or end of measurement.}

\item{fitCW.sigma}{\link{logical} (\emph{optional}):
fit CW-OSL curve using \link{fit_CWCurve} to calculate \code{sigmaF} and \code{sigmaM} (\strong{experimental}).}

\item{fitCW.curve}{\link{logical} (\emph{optional}):
fit CW-OSL curve using \link{fit_CWCurve} and derive the counts of L2 and L3
from the fitted OSL curve (\strong{experimental}).}

\item{plot}{\link{logical} (\emph{with default}):
plot output (\code{TRUE}/\code{FALSE})}

\item{...}{available options: \code{verbose} (\link{logical}).
Further arguments passed to \link{fit_CWCurve}.}
}
\value{
Returns a plot (\emph{optional}) and an S4 object of type \linkS4class{RLum.Results}.
The slot \code{data} contains a \link{list} with the following elements:

\item{summary}{\link{data.frame} summary of all relevant results}
\item{data}{the original input data}
\item{fit}{\linkS4class{RLum.Results} object if either \code{fitCW.sigma} or \code{fitCW.curve} is \code{TRUE}}
\item{args}{\link{list} of used arguments}
\item{call}{\verb{[call]} the function call}
}
\description{
Function to calculate the fast ratio of quartz CW-OSL single grain or single
aliquot curves after Durcan & Duller (2011).
}
\details{
This function follows the equations of Durcan & Duller (2011). The energy
required to reduce the fast and medium quartz OSL components to \code{x} and
\code{x2} \\% respectively using eq. 3 to determine channels L2 and L3 (start
and end). The fast ratio is then calculated from: \eqn{(L1-L3)/(L2-L3)}.
}
\section{Function version}{
 0.1.1
}

\examples{
# load example CW-OSL curve
data("ExampleData.CW_OSL_Curve")

# calculate the fast ratio w/o further adjustments
res <- calc_FastRatio(ExampleData.CW_OSL_Curve)

# show the summary table
get_RLum(res)

} 

\section{How to cite}{
King, G.E., Durcan, J., Burow, C., 2021. calc_FastRatio(): Calculate the Fast Ratio for CW-OSL curves. Function version 0.1.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.16. https://CRAN.R-project.org/package=Luminescence
}

\references{
Durcan, J.A. & Duller, G.A.T., 2011. The fast ratio: A rapid measure for testing
the dominance of the fast component in the initial OSL signal from quartz.
Radiation Measurements 46, 1065-1072.

Madsen, A.T., Duller, G.A.T., Donnelly, J.P., Roberts, H.M. & Wintle, A.G., 2009.
A chronology of hurricane landfalls at Little Sippewissett Marsh, Massachusetts, USA,
using optical dating. Geomorphology 109, 36-45.

\strong{Further reading}

Steffen, D., Preusser, F. & Schlunegger, 2009. OSL quartz age underestimation
due to unstable signal components. Quaternary Geochronology 4, 353-362.
}
\seealso{
\link{fit_CWCurve}, \link{get_RLum}, \linkS4class{RLum.Analysis},
\linkS4class{RLum.Results}, \linkS4class{RLum.Data.Curve}
}
\author{
Georgina E. King, University of Bern (Switzerland) \cr
Julie A. Durcan, University of Oxford (United Kingdom) \cr
Christoph Burow, University of Cologne (Germany)
, RLum Developer Team}
