% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdiff.R
\name{fdiff}
\alias{fdiff}
\title{Fast fractional differencing procedure of Jensen and Nielsen (2014).}
\usage{
fdiff(x, d)
}
\arguments{
\item{x}{series to be differenced}

\item{d}{memory parameter indicating order of the fractional difference.}
}
\description{
Takes the d-th difference of the series.
}
\details{
This code was first published on the \href{http://www.econ.queensu.ca/faculty/mon/software/}{university webpage of Morten Nielsen} and is 
redistributed here with the author's permission.
}
\examples{
acf(fdiff(x=rnorm(500), d=0.4))
}
\references{
Jensen, A. N. and Nielsen, M. O. (2014):
A fast fractional difference algorithm, Journal of Time Series Analysis 35(5), pp. 428-436.
}
\author{
Jensen, A. N. and Nielsen, M. O.
}
