% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lock5withR-package.R
\docType{data}
\name{MalevolentUniformsNHL}
\alias{MalevolentUniformsNHL}
\title{Malevolent Uniforms NHL}
\format{A data frame with 28 observations on the following 3 variables.
\itemize{ 
   \item{\code{NHLTeam}} {Team name}

   \item{\code{NHL_Malevolence}} {Score reflecting the "malevolence" of a
team's uniform} 
   \item{\code{ZPenMin}} {Z-score for penalty minutes} }}
\source{
Frank and Gilovich, "The Dark Side of Self- and Social Perception:
Black Uniforms and Aggression in Professional Sports", Journal of
Personality and Social Psychology, Vol. 54, No. 1, 1988, p. 74-85.
}
\description{
Perceived malevolence of uniforms and penalies for National Hockey League
(NHL) teams
}
\details{
Participants with no knowledge of the teams rated the jerseys on
characteristics such as timid/aggressive, nice/mean and good/bad. The
averages of these responses produced a "malevolence" index with higher
scores signifying impressions of more malevolent uniforms. To measure
aggressiveness, the authors used the amount of penalty minutes converted to
z-scores and averaged for each team over the seasons from 1970-1986.
}
\examples{

data(MalevolentUniformsNHL)

}
\keyword{datasets}

