% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{max_orf}
\alias{max_orf}
\title{Find the longest ORF}
\usage{
max_orf(OneSeq, reverse.strand = FALSE)
}
\arguments{
\item{OneSeq}{Is one sequence. Can be a FASTA file read by package "seqinr"
(\code{\link[seqinr]{seqinr-package}}) or just a string.}

\item{reverse.strand}{Logical. Whether find ORF on the reverse strand.}
}
\value{
Returns a list which consists ORF region (\code{ORF.Max.Seq}), length
(\code{ORF.Max.Len}) and coverage (\code{ORF.Max.Cov}) of the longest ORF.
}
\description{
This function can find the longest ORF in one sequence.
}
\details{
This function can extract the longest ORF of one sequence. It returns
the region, length and coverage of the longest ORF. Coverage is the the ratio
of ORF to transcript length. If \code{reverse.strand = TRUE}, ORF will be
found on both the forward and reverse strand.
}
\examples{
### For one sequence:
OneSeq <- c("cccatgcccagctagtaagcttagcc")
max_orf_1 <- max_orf(OneSeq, reverse.strand = TRUE)

### For a FASTA file contains several sequences:
\dontrun{
### Use "read.fasta" function of package "seqinr" to read a FASTA file:
Seqs <- read.fasta(file =
"http://www.ncbi.nlm.nih.gov/WebSub/html/help/sample_files/nucleotide-sample.txt")
}

### Or just try to use our data "demo_DNA.seq"
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

### Use apply function to find the longest ORF:
max_orf_2 <- sapply(Seqs, max_orf, reverse.strand = FALSE)
}
\author{
Han Siyu
}
