% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{crossTables}
\alias{crossTables}
\title{Cross the original MS1 peaklist with the annotation results}
\usage{
crossTables(msobject, ppm = 5, rttol = 10, dbs)
}
\arguments{
\item{msobject}{annotated msobject}

\item{ppm}{mass tolerance in ppm.}

\item{rttol}{rt tolerance to match peaks in seconds.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}
}
\value{
msobject with an annotatedPeaklist, which is a data frame with 6 
columns: mz, RT, int, LipidMSid, adduct and confidence level for the 
annotation. When multiple IDs are proposed for the same feature, they are 
sorted based on the annotation level and score.
}
\description{
Cross the original MS1 peaklist with the annotation results.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
msobject <- idPCneg(LipidMSdata2::msobjectDIAneg)
msobject <- crossTables(msobject, ppm = 10, rttol = 10)}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
