% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnt_rename.R
\name{lnt_rename}
\alias{lnt_rename}
\title{Assign proper names to LexisNexis TXT files}
\usage{
lnt_rename(x, encoding = "UTF-8", recursive = FALSE, report = FALSE,
  verbose = TRUE)
}
\arguments{
\item{x}{Name or names of LexisNexis TXT file to be renamed or a folder
location. If folder location is provided, string must end with /}

\item{encoding}{Encoding to be assumed for input files. Defaults to UTF-8
(the LexisNexis standard value).}

\item{recursive}{A logical flag indicating whether subdirectories are
searched for more txt files}

\item{report}{A logical flag indicating whether the function will return a
report which files were renamed}

\item{verbose}{A logical flag indicating whether information should be
printed to the screen.}
}
\description{
Give proper names to LN TXT files based on search term and period retrieved
from each file cover page. This information is not always delivered by
LexisNexis though. If the information is not present in the file, new file
names will be empty.
}
\details{
Can check the consistency of LexisNexis txt files. lnt_read needs at
  least Beginning, End and length in each article to work
}
\examples{
# Copy sample file to current wd
lnt_sample()

# Rename files in folder wd and report back if successful
report.df <- lnt_rename(x = lnt_sample(),
                        recursive = FALSE,
                        report = TRUE)
report.df
}
\author{
Johannes B. Gruber
}
\keyword{LexisNexis}
