% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc_SubmitOrder.R
\name{lc_SubmitOrder}
\alias{lc_SubmitOrder}
\title{Buy a note on the primary market}
\usage{
lc_SubmitOrder(loanId, amount = 25, portfolioId = NULL, LC_CRED = NULL,
  quiet = T)
}
\arguments{
\item{loanId}{Unique ID for loans. These can be found using the
ListedLoans() function.}

\item{amount}{Amount to be purchased}

\item{portfolioId}{Unique ID for the portfolio. It can be found
using the PortfoliosOwned() function.}

\item{LC_CRED}{Credential object having class LendingClub_credential. This object can be created using the \code{lc_MakeCredential()} function. You can pass the object directly as an argument to the function or alternatively, it can be read from the global environment if it was stored as "LC_CRED".}

\item{quiet}{Should the response be printed to the console}
}
\description{
Create an order to purchase a note. If the account has sufficient
funding, the note will be purchased once the loan has passed
through the funding stage.
}
\examples{
\dontrun{
SubmitOrder(12345678, 25)
SubmitOrder(12345678, 25, "myPortfolio")

#For multiple loans in a single order
SubmitOrder(loanId=c(123, 456, 789), amount= c(rep(25,3)))
}
}
