# Works Consulted <a name = "works-consulted"></a>

There are a great many tutorials, case studies and questions about PCA available for study.  We have looked at many of them!  In the course of preparing this package, we have found the following resources, given in no particular order, especially useful.

Many of these are questions asked at [Cross Validated](https://stats.stackexchange.com), which form a tremendous corpus for learning.  When studying these, be sure to look at the original question, the answers, and the comments.  Some answers are more helpful than others, and the dialog can be enlightening as well.

Finally, as you study, remember that a lot of the confusion comes from jargon that differs from discipline-to-discipline.  For example, what mathematicians call an "orthonormal basis" is an "orthogonal axis" to statisticans and a "frame of reference" to physicists (with right angles assumed, because, well, of course).  Finding these translations really helps to advance one's understanding.

* [Making sense of principal component analysis, eigenvectors & eigenvalues](https://stats.stackexchange.com/q/2691/26909)
* [What exactly is called principal component in PCA?](https://stats.stackexchange.com/q/88118/26909)
* [An intuitive guide to PCA: Ideas behind Principal Component Analysis](https://towardsdatascience.com/an-intuitive-guide-to-pca-1174055fc800) Note: behind paywall.  Good discussion of frame of reference concepts.
* [Principal component analysis (PCA) in R: which function to use?](https://stackoverflow.com/q/14249156/633251)
* [PCA and proportion of variance explained](https://stats.stackexchange.com/q/22569/26909)
* [Loadings vs eigenvectors in PCA: when to use one or another?](https://stats.stackexchange.com/q/143905/26909)
* [Simple SVD algorithms: Naive ways to calculate SVD](https://towardsdatascience.com/simple-svd-algorithms-13291ad2eef2) Note: behind paywall.
* [Relationship between SVD and PCA. How to use SVD to perform PCA?](https://stats.stackexchange.com/q/134282/26909)
* [How to reverse PCA and reconstruct original variables from several principal components?](https://stats.stackexchange.com/q/229092/26909)
* *Chemometrics: A Practical Guide* by Kenneth R. Beebe, Randy J. Pell and Mary Beth Seasholtz.  Wiley, New York, 1998. ISBN 0-471-12451-6
* *A Tutorial on Principal Components Analysis" Jonathan Shlens.  7 April 2014. [access](https://arxiv.org/abs/1404.1100).
* [Dimensionality Reduction For Dummies — Part 1: Intuition](https://towardsdatascience.com/https-medium-com-abdullatif-h-dimensionality-reduction-for-dummies-part-1-a8c9ec7b7e79) Note: behind paywall.
* [You Don’t Know SVD: Truly Understanding SVD — The Intuitive Core Idea](https://towardsdatascience.com/svd-8c2f72e264f) Note: behind paywall.
* [The Math of Principal Components Analysis](https://medium.com/analytics-vidhya/the-math-of-principal-component-analysis-pca-bf7da48247fc)
