% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rotation.R
\name{Rotate}
\alias{Rotate}
\title{Rotates a geometric object}
\usage{
Rotate(object, fixed, angle)
}
\arguments{
\item{object}{geometric object of type line, polygon or segment, previously created with any of the functions in the package}

\item{fixed}{Vector containing the xy-coordinates of the only point of the plane which remains fixed during rotation}

\item{angle}{Angle of rotation in degrees (0-360), considering the clockwise direction}
}
\value{
Returns a geometric object which is the rotation of the original one, following the clockwise direction
}
\description{
\code{Rotate} rotates a geometric object of any of the following types: line, polygon or segment
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Poly <- CreatePolygon(P1, P2, P3)
Draw(Poly, "blue")
fixed <- c(-1,-1)
angle <- 30
Poly_rotated <- Rotate(Poly, fixed, angle)
Draw(Poly_rotated, "orange")
fixed <- c(2,0)
Poly_rotated <- Rotate(Poly, fixed, angle)
Draw(Poly_rotated, "transparent")
}
