% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeWeight.R
\name{normalizeWeight}
\alias{normalizeWeight}
\title{To normalize weight values.}
\usage{
normalizeWeight(normalize, weight, data)
}
\arguments{
\item{normalize}{is a boolean value.}

\item{weight}{is a numeric vector.}

\item{data}{is a data.frame.}
}
\value{
Numeric vector with updated weights.
}
\description{
To normalize weight values if \code{normalize} = TRUE.
}
\details{
This function allows users to normalize weights.

If there is not any weight, the function will create a numeric vector of "1".

If normalize = TRUE, the function will make every weight value as a "[0:1]" value.

If normalize = FALSE, the function will not make any changes, weights will be the same.
}
\examples{

data <- data.frame(matrix(c(1:10),ncol = 2))

weight1 <- c(0.6,0.4)
weight2 <- c(2,4)

normalizeWeight(FALSE, weight1, data)

normalizeWeight(TRUE, weight2, data)

normalizeWeight(FALSE, weight2, data)

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
