% Generated by roxygen2 (4.0.1): do not edit by hand
\name{o2.at.sat}
\alias{o2.at.sat}
\alias{o2.at.sat.base}
\title{Calculates the equilibrium saturation concentration of oxygen in water at the supplied conditions}
\usage{
o2.at.sat.base(temp, baro, altitude = 0,
   salinity = rep(0, length(temp)), model = "garcia")
o2.at.sat(ts.data, baro, altitude = 0, salinity = 0, model = "garcia")
}
\arguments{
\item{ts.data}{Object of class data.frame with two named columns \dQuote{datetime} and \dQuote{wtr} (water temp in deg C).}

\item{temp}{a numeric vector of water temperature in degrees Celsius.}

\item{baro}{barometric pressure in millibars.}

\item{altitude}{a numeric value indicating the elevation above mean sea level in meters.
Defaults to mean sea level. An alternative to supplying barometric pressure.}

\item{salinity}{a numeric vector of salinity in PSU. Defaults to zero.
Length must be one or equal to length of temperature.}

\item{model}{the empirical model to be used, \code{"weiss"} and \code{"benson"} are the two available options. They correspond to the references described below.}
}
\value{
The equilibration concentration at the supplied conditions in mg/L of oxygen.
}
\description{
Used to calculate the equilibrium concentration of oxygen in water.
The equilibration concentration of oxygen in water varies with both
temperature, salinity, and the partial pressure of oxygen in contact
with the water (calculated from supplied elevation or barometric pressure).
}
\examples{
temp.range = 1:25
sal.range = 1:25

par(mfrow=c(1,2))
plot(temp.range, o2.at.sat.base(temp.range), xlab='Temperature (C)',
ylab='Oxygen Saturation (mg/L)')
plot(o2.at.sat.base(rep(20,25), salinity=sal.range), xlab='Salinity (PSU)', ylab='')
}
\author{
Luke A Winslow
}
\references{
Benson, B. B., & Krause, D. (1984). \emph{The concentration and isotopic
fractionation of oxygen dissolved in freshwater and seawater in
equilibrium with the atmosphere}. Limnology and Oceanography,
29(3), 620-632. doi:10.4319/lo.1984.29.3.0620

Weiss, R. (1970). \emph{The solubility of nitrogen, oxygen and argon in water and seawater}.
Deep Sea Research and Oceanographic Abstracts, 17(4), 721-735. doi:10.1016/0011-7471(70)90037-9
}
\seealso{
\link{water.density}, \link{o2.at.sat.base}
}
\keyword{math,}
\keyword{methods}

