% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_maxlad_metrics.R
\name{get_plots_effective}
\alias{get_plots_effective}
\title{Plots of fuel layers with LAD percentage > 10}
\usage{
get_plots_effective(LAD_profiles, effective_LAD, min_height = 1.5)
}
\arguments{
\item{LAD_profiles}{Original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function in the \emph{leafR} package).
An object of the class text.}

\item{effective_LAD}{Tree metrics with gaps (distances), fuel base heights, and depths of fuel layers with LAD percentage greater than 10
(output of [get_layers_lad()] function).
An object of the class text.}

\item{min_height}{Numeric value for the actual minimum base height (in meters).}
}
\value{
A plot drawing fuel layers with LAD percentage greater than 10.
}
\description{
This function plots fuel layers with LAD percentage greater than 10.
}
\examples{
library(ggplot2)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

# Before running this example, make sure to run get_layers_lad().
if (interactive()) {
effective_LAD <- get_layers_lad()
LadderFuelsR::effective_LAD$treeID <- factor(LadderFuelsR::effective_LAD$treeID)

trees_name1 <- as.character(effective_LAD$treeID)
trees_name2 <- factor(unique(trees_name1))

# Generate plots for fuels LAD metrics
plots_trees_LAD <- get_plots_cbh_LAD(LAD_profiles, effective_LAD, min_height = 1.5)
}
}
\seealso{
\code{\link{get_layers_lad}}
}
\author{
Olga Viedma, Carlos Silva, JM Moreno and A.T. Hudak
}
