#' Data about pollution
#'
#' A dataset containing 30 attributes of pollution. The variables are as follows:
#'
#' \itemize{
#'   \item Occupation.
#'   \item Age.
#'   \item Bmi.
#'   \item Waist circunference.
#'   \item Time in job.
#'   \item Work shift.
#'   \item Exhlaled carbon monoxide.
#'   \item PM25.
#'   \item Exposure.
#'   \item ETS.
#'   \item ETS at home.
#'   \item ETS at work.
#'   \item HAS_DM.
#'   \item Haemoglobin.
#'   \item Hematocrit.
#'   \item White blood cells.
#'   \item Total Cholesterol.
#'   \item HDL.
#'   \item LDL.
#'   \item Albumin.
#'   \item Fasting blood clucose.
#'   \item FVCmeas.
#'   \item FVC pred.
#'   \item FEV1meas.
#'   \item FEV1 pred.
#'   \item FEVFVCmeas.
#'   \item FEF25 75 FVCmeas.
#'   \item FEF25 75 FVC pred.
#'   \item PFEmeas.
#'   \item PFE pred.
#'   \item Age. age of the property in years
#' }
#'
#' @docType data
#' @keywords datasets
#' @name pollution
#' @usage data(pollution)
#' @format A data frame with 101 rows and 30 variables
#' @references  Santos et al. (2016). Association between Traffic Air Pollution and Reduced Forced Vital Capacity: A Study Using Personal Monitors for Outdoor Workers.
#'  \emph{PLoS ONE}, \strong{11}(10): e0163225. \doi{10.1371/journal.pone.0163225}.
NULL
