% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_functions.R
\name{make_matrices_dens}
\alias{make_matrices_dens}
\title{Build a standardised P-Spline design matrix and the associated P-Spline penalty matrix}
\usage{
make_matrices_dens(
  x,
  k,
  type = "real",
  degree = 3,
  npoints = 10000,
  diff_order = 2,
  pow = 0.5
)
}
\arguments{
\item{x}{data vector}

\item{k}{number of basis functions}

\item{type}{type of the data, either \code{"real"} for data on the reals, \code{"positive"} for data on the positive reals or \code{"circular"} for circular data like angles.}

\item{degree}{degree of the B-spline basis functions, defaults to cubic B-splines}

\item{npoints}{number of points used in the numerical integration for normalizing the B-spline basis functions}

\item{diff_order}{order of differencing used for the P-Spline penalty matrix for each data stream. Defaults to second-order differences.}

\item{pow}{power for polynomial knot spacing

Such non-equidistant knot spacing is only used for \code{type = "positive"}.}
}
\value{
list containing the design matrix \code{Z}, the penalty matrix \code{S}, the prediction design matrix \code{Z_predict}, the prediction grid \code{xseq}, and details for the basis expansion.
}
\description{
This function builds the B-spline design matrix for a given data vector. 
Importantly, the B-spline basis functions are normalised such that the integral of each basis function is 1, hence this basis can be used for spline-based density estimation, when the basis functions are weighted by non-negative weights summing to one.
}
\examples{
modmat = make_matrices_dens(x = (-50):50, k = 20)
modmat = make_matrices_dens(x = 1:100, k = 20, type = "positive")
modmat = make_matrices_dens(x = seq(-pi,pi), k = 20, type = "circular")
}
