% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_functions.R
\name{make_matrices}
\alias{make_matrices}
\title{Build the design matrix and the penalty matrix for models involving penalised splines based on a formula and a data set}
\usage{
make_matrices(formula, data, knots = NULL)
}
\arguments{
\item{formula}{right side of a formula as used in \code{mgcv}}

\item{data}{data frame containing the variables in the formula}

\item{knots}{optional list containing user specified knot values to be used for basis construction

For most bases the user simply supplies the knots to be used, which must match up with the k value supplied (note that the number of knots is not always just k).
See \code{mgcv} documentation for more details.}
}
\value{
a list containing the design matrix \code{Z}, the penalty matrix \code{S}, the \code{formula}, the \code{data} and the \code{knots}
}
\description{
Build the design matrix and the penalty matrix for models involving penalised splines based on a formula and a data set
}
\examples{
modmat = make_matrices(~ s(x), data.frame(x = 1:10))
}
