% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateprobs_g.R
\name{stateprobs_g}
\alias{stateprobs_g}
\title{Calculate conditional local state probabilities for inhomogeneous HMMs}
\usage{
stateprobs_g(delta, Gamma, allprobs)
}
\arguments{
\item{delta}{Initial distribution of length N}

\item{Gamma}{Array of transition probability matrices of dimension c(N,N,n-1), as in a time series of length n, there are only n-1 transitions.}

\item{allprobs}{Matrix of state-dependent probabilities/ density values of dimension c(n, N)}
}
\value{
Matrix of conditional state probabilities of dimension c(n,N)
}
\description{
Computes \cr \cr
\eqn{\Pr(S_t = j \mid X_1, ..., X_T)} \cr \cr
}
\examples{
Gamma = tpm_g(runif(99), matrix(c(-1,-1,1,-2), nrow = 2, byrow = TRUE))
delta = c(0.5, 0.5)
allprobs = matrix(runif(200), nrow = 100, ncol = 2)

probs = stateprobs_g(delta, Gamma, allprobs)
}
