% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitprobit.R
\name{fitprobit}
\alias{fitprobit}
\title{Fit a Probit Regression to Dose-Effect Data}
\usage{
fitprobit(dat)
}
\arguments{
\item{dat}{A data frame of toxicity data, including at least three variables:
dose (the concentration of the tested chemical),
ntot (the number of individuals tested), and
nfx (the number of affected individuals).}
}
\value{
A an object of class \code{\link{glm}}.
}
\description{
Fit a probit regression to dose-effect data, using the log10 of the dose as
  the response.
}
\details{
Only those rows with \code{dose > 0}, \code{ntot > 0}, and \code{nfx >= 0}
  are used in fitting the model.
}
\examples{
toxdat <- data.frame(
 dose=c(0.05, 0.0625, 0.125, 0.25, 0.5, 1),
  ntot=rep(8, 6),
  nfx = c(0, 1, 4, 4, 6, 8))
fitprobit(toxdat)
}
