% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.ltrccif,}
\alias{print.ltrcrrf}
\title{Print Summary Output of a ltrccif object or a ltrcrrf object}
\usage{
print(x)
}
\arguments{
\item{x}{an object of class \code{ltrccif} or \code{ltrcrrf}.}
}
\description{
Print summary output after a LTRCCIF or a LTRCRRF model is built.
This is the default print method for objects in the class of \code{\link{ltrccif}} or 
\code{\link{ltrcrrf}}.
}
\examples{

library(survival)
Formula = Surv(Start, Stop, Event) ~ age + alk.phos + ast + chol + edema
# Built a LTRCCIF forest on the time-varying data by specifying id, with mtry specified:
LTRCCIFobj = ltrccif(formula = Formula, data = pbcsample, id = ID, mtry = 3, ntree = 50L)
print(LTRCCIFobj)

# Built a LTRCCIF forest on the time-invariant data, with resampling, with mtry specified:
LTRCCIFobj = ltrccif(formula = Formula, data = pbcsample, samptype = "swr",
                     mtry = 3, ntree = 50L)
print(LTRCCIFobj)
}
\seealso{
\code{\link{ltrccif}}, \code{\link{ltrcrrf}}
}
