% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_summary.R
\name{conf_interval}
\alias{conf_interval}
\alias{R2}
\alias{regression_summary}
\alias{anova_summary}
\title{Summaries of regression models}
\usage{
conf_interval(model, level = 0.95, show_p = FALSE)

R2(model)

regression_summary(model)

anova_summary(...)
}
\arguments{
\item{model}{A model as produced by \code{model_train()}, \code{lm()}, \code{glm()}, and so on}

\item{level}{Confidence level to use in \code{conf_interval()} (default: 0.95)}

\item{show_p}{For \code{conf_interval()}, append the p-value to the report.}

\item{\ldots}{One or more models (for ANOVA)}
}
\value{
a data frame
}
\description{
The summaries are always in the form of a data frame
\itemize{
\item \code{conf_interval()} --- displays coefficients and their confidence intervals
\item \code{R2()} --- R-squared of a model together with related measures such as F, adjusted R-squared,
the p-value, and degrees of freedom used in calculating the p-value.
\item \code{regression_summary()} -- A regression report in data-frame format.
\item \code{anova_summary()} --- An ANOVA report in data-frame format. If only one model
is passed as an argument, the data frame will have one line per model term. If multiple models
are given as arguments, the ANOVA report will show the increments from one model
to the next.
}
}
\details{
Many of these are  wrappers around \code{broom::tidy()} used to
emphasize to students that the results are a summary in the form of a regression
report, similar to the summaries produced by \code{stats::confint()}, \code{stats::coef()}, etc.
}
\examples{
Model <- FEV |> model_train(FEV ~ age + smoker)
Model |> conf_interval()
Model |> R2()
Model |> anova_summary()

}
