% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_MWA.R
\name{NDVI}
\alias{NDVI}
\title{NDVI}
\usage{
NDVI(Red, NIR)
}
\arguments{
\item{Red}{Raster* object, red band of remote sensing imagery}

\item{NIR}{Raster* object, NIR band of remote sensing imagery}
}
\value{
RasterLayer
}
\description{
Function for NDVI calculation
}
\examples{
red <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(red) = runif(10000, min=0.1, max=0.4)

NIR <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(NIR) = runif(10000, min=0.1, max=0.6)

NDVI(Red = red, NIR = NIR)
}
