% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LSD.plotmatrix.r
\name{plotmatrix}
\alias{LSD.plotmatrix}
\alias{plotmatrix}
\title{Visualize two-dimensional data}
\usage{
plotmatrix(input, xlim = NULL, ylim = NULL, xlab = "", ylab = "",
  main = "plotmatrix", type = "l", lwd = 2, at = NULL, xlabels = NULL,
  ltys = NULL, add = FALSE, cols = NULL, ...)
}
\arguments{
\item{input}{a matrix with numerical entries.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{xlab}{x lab, standard graphics parameter.}

\item{ylab}{y lab, standard graphics parameter.}

\item{main}{title of the plot, standard graphics parameter.}

\item{type}{what 'type' of plot should be drawn (to be passed to points).}

\item{lwd}{a positive number giving the line width.}

\item{at}{a integer vector containing the x-positions corresponding to the columns of 'input'.}

\item{xlabels}{a character vector containing labels for the x-axis.}

\item{ltys}{a numeric vector giving the line types for each row of 'input'.}

\item{add}{logical: if \code{TRUE} (\code{FALSE} by default), lines are added to existing plot.}

\item{cols}{a character vector of R build-in colors.}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Plot the rows of a matrix as lines along the cols.
}
\examples{
len = 20
x = sin(seq(0,2*pi,length=len*2))
fun = function(){n=sample(1:len,1); return(x[n:(n+len-1)])}
input = t(replicate(7,fun(),simplify=TRUE))
input = input + rnorm(length(input))/2

plotmatrix(input,cols=1:7)
}
\author{
Achim Tresch, Bjoern Schwalb
}
\seealso{
\code{\link{clusterplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{matrix}

