% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ROCtest.R
\name{ROCtest}
\alias{ROCtest}
\title{Display ROC curve and related AUC statistic, or sensitivity-specificity plot of glm
with binomial family.}
\format{\describe{
\item{x}{
The function has three arguments: modelname, folds, type of plot}
}}
\usage{
ROCtest(model= model, fold=10, type=c("ROC","Sensitivity"))
}
\arguments{
\item{model}{model name}

\item{fold}{number of k-folds}

\item{type}{type of plot}
}
\value{
plot
}
\description{
Provides two options following the glm() function with binomial family.
1: Senstivity-specificity plot with optimal cut point statistic
2: ROC plot with Area Under Curve (AUC) statistic
}
\details{
ROCtest is a post-estimation function for logistic regression, following the use
of glm(). Options to display a sensitivity-specificity plot or ROC curve are
available.
}
\note{
ROCtest() must be loaded into memory in order to be effectve. As a function in LOGIT,
it is immediately available to a user.
}
\examples{
library(MASS)
 library(LOGIT)
 data(R84)
 R84$cage <- R84$age - mean(R84$age)
 R84$cdoc <- R84$docvis - mean(R84$docvis)
 mylogit <- glm(outwork ~ cdoc + female + kids + cage + factor(edlevel),
 family=binomial, data=R84)
 summary(mylogit)
 ROCtest(mylogit, fold=10, type="Sensitivity")
 ROCtest(mylogit, fold=10, type="ROC")
}
\author{
Rafael de Souza, ELTE, Hungary,
Joseph M. Hilbe, Arizona State University.
}
\references{
Hilbe, Joseph M. (2015), Practical Guide to Logistic Regression, Chapman & Hall/CRC.

Hilbe, Joseph M. (2009), Logistic Regression Models, Chapman & Hall/CRC.
}
\seealso{
\code{\link{glm}}
}
\keyword{models}

