% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{scatterplot}
\alias{scatterplot}
\title{Scatterplot for Continuous Variables}
\usage{
scatterplot(
  data,
  formula,
  columns,
  format = NULL,
  group = NULL,
  transform = NULL,
  facet = "grid",
  alpha.point = 1,
  type.diag = "boxplot",
  bins = NULL,
  position.bar = "identity",
  linewidth.density = NULL,
  alpha.area = NULL,
  method.cor = "pearson",
  name.cor = "r",
  size.cor = NULL,
  digits = c(3, 2),
  display.NA = NULL,
  color = NULL,
  xlim = NULL,
  ylim = NULL,
  size.axis = NULL,
  size.legend = NULL,
  size.facet = NULL
)
}
\arguments{
\item{data}{[data.frame] dataset containing the variables to be displayed.}

\item{formula}{[formula] formula indicating the variables to be used (outcome~time|id). Long format only.}

\item{columns}{[character vector] Columns whose numerical values are to be displayed. Wide format only.}

\item{format}{[character] Is the dataset in the long (\code{"long"}) or wide (\code{"wide"}) format?}

\item{group}{[character] optional group variable used to color the points, stratify the histogram/density and correlation.}

\item{transform}{[character or function] optional transformation to be applied on the outcome.}

\item{facet}{[character] whether to use \code{ggplot:::facet_grid} (\code{"grid"}) or \code{ggh4x::facet_grid2} (\code{"grid2"}).}

\item{alpha.point}{[numeric] the transparency level used to display the points in the scatterplot.}

\item{type.diag}{[character] type of graphical display on the diagonal: \code{"boxplot"},  \code{"histogram"}, or \code{"density"}.}

\item{bins}{[character or numeric vector] algorithm or values or number of values used to create the histogram cells.
When using \code{facet="grid2"} and \code{density=TRUE} a character of length two indicating the bandwith and the kernel to be used.
See \code{ggplot2::stat_density}.}

\item{position.bar}{[character] passed to \code{geom_histogram} (argument \code{position}).
Only relevant when having multiple groups and using \code{ggh4x::facet_grid2}.}

\item{linewidth.density}{[numeric,>0] width of the lines on the density plot.}

\item{alpha.area}{[numeric, 0-1] the transparency level used to display the area under the density curve or histogram.}

\item{method.cor}{[character] estimator of the correlation. Argument passed to \code{stats::cor}.
When \code{NA}, the correlation is not displayed.}

\item{name.cor}{[character] character used to represent the correlation. By default \code{"r"} but can be changed to \code{"\u03C1"} to display the greek letter \eqn{\rho}.}

\item{size.cor}{[numeric,>0] size of the font used to display the correlation or information about missing values.}

\item{digits}{[numeric of length 2] number of digits used to display the correlation or round the percentage of missing values.}

\item{display.NA}{[0:2 or "only"] Should the number of missing values be displayed. When taking value 2, will also display the percentage of missing values.}

\item{color}{[character vector] color used to display the values for each group.}

\item{xlim}{[numeric,>0 or "common"] range of the x-axis.}

\item{ylim}{[numeric,>0 or "common"] range of the y-axis.}

\item{size.axis}{[numeric,>0] size of the font used to display the tick labels.}

\item{size.legend}{[numeric,>0] size of the font used to display the legend. Can have a second element to control the size of the legend key.}

\item{size.facet}{[numeric,>0] size of the font used to display the facets (row and column names).}
}
\value{
a list of ggplot objects (\code{facet="grid"}) or a ggplot object (\code{facet="grid2"})
}
\description{
Produce a matrix of plot for continuous variables: scatterplots, histograms, correlation and missing values.
Inspired from the \code{ggpairs} function of the R package GGally.
}
\details{
In the long format, the outcome variable contains the numerical values to be displayed.
The time variable will be used to spit outcome and display each split separately or jointly with one other split.
The identifier links the outcome values across time.
}
\examples{
data(gastricbypassL, package = "LMMstar")
gastricbypassL$group <- as.numeric(gastricbypassL$id) \%\% 3
data(gastricbypassW, package = "LMMstar")

## single group (wide or long format)
scatterplot(gastricbypassL, formula = weight~time|id)
scatterplot(gastricbypassW, columns = paste0("weight",1:4))

\dontrun{
## use histogram instead of boxplot
scatterplot(gastricbypassL, formula = weight~time|id, type.diag = "hist")
scatterplot(gastricbypassL, formula = weight~time|id, type.diag = "hist", bins = 15)

## same scale
scatterplot(gastricbypassL, formula = weight~time|id,
            xlim = "common", ylim = "common")

## transform outcome
scatterplot(gastricbypassL, formula = weight~time|id, transform = "log")

## handling missing values
scatterplot(gastricbypassL, formula = glucagonAUC~time|id)

## coloring per group
scatterplot(gastricbypassL, formula = weight~time|id, group = "group")

## only display NAs
scatterplot(gastricbypassL, formula = glucagonAUC~time|id,
            display.NA = "only", group = "group")
scatterplot(gastricbypassL, formula = glucagonAUC~time|id,
            display.NA = "only", group = "group", size.legend = c(15,2))
}
}
\keyword{utilities}
