% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.lmmelsm}
\alias{predict.lmmelsm}
\title{Predict method for lmmelsm objects.}
\usage{
\method{predict}{lmmelsm}(
  object,
  newdata = NULL,
  prob = 0.95,
  summarize = TRUE,
  include_error = TRUE,
  ...
)
}
\arguments{
\item{object}{lmmelsm object.}

\item{newdata}{Data.frame (Default: NULL). If NULL, uses original data.frame.}

\item{prob}{Numeric (Default: .95). Amount of probability mass contained in the credible interval.}

\item{summarize}{Logical (Default: TRUE). Whether to return posterior summaries (TRUE) or MCMC samples (FALSE).}

\item{include_error}{Logical (Default: TRUE). If TRUE, then include stochastic realizations in outcome variables.}

\item{...}{Not used.}
}
\value{
List. If summarize is TRUE, then a list of outcome (eta, eta_logsd) and indicator (y) posterior predictive distribution summaries. If FALSE, an N-length list of lists of outcome and indicator MCMC samples.
}
\description{
Generates posterior predictions from fitted LMMELSM object.
}
\details{
If the grouping variable is missing, or contains NAs, then new random effects are generated from the posterior random effect distribution.
Where the grouping variables are not missing, the posterior standardized, orthogonalized random effects are obtained from the fitted model, and used as a basis for predicted random effects.
Because the standardized, orthogonalized random effects are used, one can include different between-group variance values to predict new RE variances, and therefore a different random effect value.
That is, the random effect, conditional on new between-group variance model covariates, is equal to: \deqn{u_i = z_i U D_i}, where \eqn{D_i} is the predicted between-group random effect SD, U is the upper cholesky factorization of the random effect correlations, and \eqn{z_i} is the standardized, orthogonalized random effect for group i.
}
\author{
Stephen Martin
}
