% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICDelta_up.R
\name{getDeltaH_up}
\alias{getDeltaH_up}
\title{Estimation of the optimal \code{H_delta} value to guarantee performance in the upward CUSUM control chart}
\usage{
getDeltaH_up(
  n_I,
  alpha,
  beta,
  beta_ratio,
  H_plus,
  a,
  b,
  ARL_esp,
  m,
  N_init,
  N_final,
  known_alpha
)
}
\arguments{
\item{n_I}{Sample size in Phase I.}

\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between beta and its estimate.}

\item{H_plus}{Initial upper limit of the CUSUM chart.}

\item{a}{Tolerance level for the expected ARL (0 <= a < 1).}

\item{b}{Tolerance level for the expected ARL (0 < b < 1).}

\item{ARL_esp}{Desired expected ARL value.}

\item{m}{Number of states in the Markov matrix.}

\item{N_init}{Number of initial iterations.}

\item{N_final}{Number of final iterations.}

\item{known_alpha}{Indicates whether \code{alpha} is known (\code{TRUE}) or needs to be estimated (\code{FALSE}).}
}
\value{
A numeric value corresponding to the optimal \code{H_delta} for the upward CUSUM control chart, ensuring the expected performance.
}
\description{
This function calculates the optimal \code{H_delta} value that ensures specific performance in the Gamma CUSUM
control chart for upward detection. It relies on Monte Carlo simulations and an iterative adjustment process
to determine the appropriate value.

Following the methodology proposed by Madrid-Alvarez, Garcia-Diaz, and Tercero-Gomez (2024),
this function allows adjusting \code{H_delta} for different sample size scenarios, ensuring that the control chart
maintains the expected performance in terms of ARL.
\subsection{Features:}{
\itemize{
\item Implements Monte Carlo simulations to estimate \code{H_delta}.
\item Based on parameter estimates obtained in Phase I.
\item Iteratively adjusts \code{H_delta} until the specified ARL is reached.
\item Displays total execution time using \code{tictoc}.
}
}

\subsection{\strong{Recommendations}}{
\itemize{
\item This function is useful for estimating \code{H_delta} values in scenarios where the sample size differs from the values reported in the reference article:

\strong{Madrid-Alvarez, H. M., Garcia-Diaz, J. C., & Tercero-Gomez, V. G. (2024).}
\emph{A CUSUM control chart for gamma distribution with guaranteed performance.}
Quality and Reliability Engineering International, 40(3), 1279-1301.
\item \strong{The adjustment process is iterative and computationally demanding}, as its execution time depends on the number of iterations (\code{N_init + N_final}) and the sample size (\code{n_I}).
\item It is recommended to establish an appropriate convergence criterion to optimize execution time without compromising the accuracy of \code{H_delta} estimation.
\item For selecting values of \code{H_plus}, \code{a}, and \code{b}, refer to the reference article, which presents specific strategies and recommendations for calibration.
}
}
}
\examples{
\donttest{
getDeltaH_up(n_I = 100, alpha = 1, beta = 1, beta_ratio = 2, H_plus = 6.8313,
             a = 0.1, b = 0.05, ARL_esp = 370, m = 100,
             N_init = 10, N_final = 1000, known_alpha = TRUE)
             }

}
