% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICDeltaL_down.R
\name{getDeltaHL_down}
\alias{getDeltaHL_down}
\title{Estimation of the \code{H_delta} parameter with learning for downward detection in CUSUM Gamma charts}
\usage{
getDeltaHL_down(
  n_I,
  alpha,
  beta,
  beta_ratio,
  H_minus,
  a,
  b,
  ARL_esp,
  replicates,
  N_init,
  N_final,
  known_alpha,
  K_l,
  delay,
  tau
)
}
\arguments{
\item{n_I}{Sample size in Phase I.}

\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between \code{beta} and its posterior estimate.}

\item{H_minus}{Lower limit of the CUSUM chart.}

\item{a}{Tolerance level for the expected ARL (0 <= a < 1).}

\item{b}{Tolerance level for the expected ARL (0 < b < 1).}

\item{ARL_esp}{Desired expected ARL value.}

\item{replicates}{Number of replications in the Monte Carlo simulation.}

\item{N_init}{Initial iterations for adjustment.}

\item{N_final}{Final iterations for averaging \code{H_delta}.}

\item{known_alpha}{\code{TRUE} if \code{alpha} is fixed, \code{FALSE} if it must be estimated.}

\item{K_l}{Secondary control threshold for parameter update.}

\item{delay}{Number of observations before updating \code{beta0_est}.}

\item{tau}{Time point where \code{beta} changes.}
}
\value{
A numeric value corresponding to the optimal \code{H_delta} estimated with learning for the downward CUSUM control chart.
}
\description{
This function calculates the optimal value of \code{H_delta} using a dynamic learning scheme
based on the \code{ARL_Clplus} function, iteratively adjusting \code{H_delta} to achieve an \strong{expected ARL}
with greater accuracy and adaptability.

Based on the methodology proposed by Madrid-Alvarez, Garcia-Diaz, and Tercero-Gomez (2024),
this function allows adjusting \code{H_delta} in different sample size scenarios, ensuring that
the control chart progressively adapts to changes in the Gamma distribution.
\subsection{Features:}{
\itemize{
\item Implements Monte Carlo simulations to estimate \code{H_delta}.
\item Relies on parameter estimates obtained in Phase I.
\item Iteratively adjusts \code{H_delta} until the specified ARL is reached.
\item Incorporates a cautious learning mechanism to improve adjustment accuracy.
\item Displays total execution time using \code{tictoc}.
}
}

\subsection{\strong{Recommendations}}{
\itemize{
\item This function is useful for estimating \code{H_delta} values when the sample size differs from those reported in the reference article:

\strong{Madrid-Alvarez, H. M., Garcia-Diaz, J. C., & Tercero-Gomez, V. G. (2024).}
\emph{A CUSUM control chart for the Gamma distribution with cautious parameter learning.}
Quality Engineering, 1-23.
\item \strong{The adjustment process is iterative and computationally demanding}, as execution time depends on the number of iterations (\code{N_init + N_final})
and the sample size (\code{n_I}).
\item It is recommended to define an appropriate convergence criterion to optimize execution time without compromising accuracy in the estimation of \code{H_delta}.
\item For selecting values of \code{a}, \code{b}, \code{k_l}, \code{delay}, \code{tau}, and \code{H_minus}, refer to the reference article, which presents specific strategies
for their calibration in different scenarios.
}
}
}
\examples{
\donttest{
getDeltaHL_down(n_I = 200, alpha = 1, beta = 1, beta_ratio = 1/1.5,
              H_minus = -6.2913, a = 0.1, b = 0.05, ARL_esp = 370,
              replicates = 10, N_init = 100, N_final = 1000,
              known_alpha = TRUE, K_l = 0.7, delay = 25, tau = 1)
              }

}
