% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDheatmap.addScatterplot.R
\name{LDheatmap.addScatterplot}
\alias{LDheatmap.addScatterplot}
\title{Add a scatter plot to an LDheatmap object}
\usage{
LDheatmap.addScatterplot(LDheatmap, P, height = 0.2, ylab = NULL, ylim=NULL,
type = "points")
}
\arguments{
\item{LDheatmap}{An object of class LDheatmap.}

\item{P}{A vector with the values to be plotted as the y axis.}

\item{height}{The height of the plot.}

\item{ylab}{The y axis label.}

\item{ylim}{The y axis limits.}

\item{type}{Plot type. Possible values are \code{"points"} (the default), \code{"lines"} or \code{"both"}.}
}
\value{
An object of class LDheatmap given as an argument, with the \code{grob}
\code{LDheatmapGrob} modified to inclue the \code{"association"} child grob.
}
\description{
Add a scatter plot to an LDheatmap object.
The x axis is the map of genetic distances of the SNPs.
}
\details{
The function creates an \code{"association"} \code{grob} and adds it to the \code{LDheatmap} object.
Then it pushes a \code{viewport} and draws the \code{LDheatmapGrob} onto it.
}
\note{
The function can display at most two scatter plots in the default setting. To add three or more scatter plots 
in the same viewport, the user can change the input value \code{"location"} from function \code{constructVP} which is 
the function inside the \code{LDheatmap.addScatterplot}. The default \code{"location"} value is 0.03, for adding the 
third scatter plot, user needs to set the \code{"location"} to 0.23, where 0.2 units is the height of the scatter plot.
For the fourth scatter plot, set the \code{"location"} to 0.43 etc. 
See Examples for usage.
}
\examples{
# Load the package's data set
data("CEUSNP"); data("CEUDist")
# Produce an LDheatmap object
MyLDheatmap <- LDheatmap(CEUSNP, genetic.distances = CEUDist, flip = TRUE)
# Generate an arbitrary vector of values to plot
Yvalues <- seq(length = length(MyLDheatmap$genetic.distances), from = 0.01, to = 0.5)
# Add scatter plot
assoc <- LDheatmap.addScatterplot(MyLDheatmap, Yvalues)
######## Adding three or more scatter plots ########
# Redefine LDheatmap.addScatterplot() to display the third scatter plot
LDheatmap.addScatterplot_test3 <- function(LDheatmap, P, height=0.2, ylab=NULL, 
ylim=NULL, type="points",color,pch) {
if (dim(LDheatmap$LDmatrix)[1] != length(P)) {
print("Length of vector not equal number of SNPs in LDheatmap")
return()

flip <- !is.null(LDheatmap$flipVP)
vp <- constructVP(LDheatmap$LDheatmapGrob, 0.23, flip)
......
return(LDheatmap)
}}
environment(LDheatmap.addScatterplot_test3) <- asNamespace('LDheatmap')

}
\seealso{
\code{\link{LDheatmap}}
}
\author{
Sigal Blay <sblay@sfu.ca> and more
}
\keyword{hplot}
