% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIP.R
\name{AIPbootVrnc}
\alias{AIPbootVrnc}
\title{Calculate variance of AIP using Bootstrapping.}
\usage{
AIPbootVrnc(
  TG,
  HDL,
  sampleSize = length(TG),
  SI = TRUE,
  noOfReps = 1000,
  pb = F
)
}
\arguments{
\item{TG}{A vector or data frame column containing the triglyceride (TG)
values to be used for
the calculation of the variance of the Atherogenic Index of Plasma (AIP)
using bootstrapping. TG and HDL must be of the same length.}

\item{HDL}{A vector or data frame column containing the high density
lipoprotein (HDL) values
to be used for the calculation of the variance of the Atherogenic Index
of Plasma (AIP)
using bootstrapping.
TG and HDL must be of the same length.}

\item{sampleSize}{(default = length of TG or HDL) The sample size that will be
generated at each bootstrapping sampling
round. Size of bootstrapped samples cannot be larger than the original.}

\item{SI}{Boolean (default=TRUE). AIP is by definition calculated using SI
units for TG and HDL
(mmol/L). If mg/dl units are provided instead, SI must be set to FALSE.}

\item{noOfReps}{(default = 1000) Number of repetitions of the bootstrapping.}

\item{pb}{Display a progress bar (default = FALSE)}
}
\value{
It returns a data table with four columns. The first
column contains the mean of the AIP values for each iteration. The second
column contains the median of each iteration.The third
column contains the variance and the fourth column contains
the CV of each iteration. It also returns the median of the "Mean", "Var"
and "CV" columns of the data table.
}
\description{
This function can be used to calculate the variance of the
Atherogenic Index of Plasma (AIP) using Bootstrapping.
}
\examples{
\dontrun{
AIPbootstrVar = AIPbootVrnc(sampleA$TG,sampleA$HDL)
}
}
