% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Treee.R
\name{Treee}
\alias{Treee}
\title{Classification trees with Linear Discriminant Analysis terminal nodes}
\usage{
Treee(
  formula,
  data,
  missingMethod = c("meanFlag", "newLevel"),
  splitMethod = "LDscores",
  pruneMethod = "none",
  numberOfPruning = 10,
  maxTreeLevel = 4,
  minNodeSize = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{an object of class \link{formula}, which has the form \code{class ~ x1 + x2 + ...}}

\item{data}{a data frame that contains both predictors and the response.
Missing values are allowed in predictors but not in the response.}

\item{missingMethod}{Missing value solutions for numerical variables and
factor variables. \code{'mean'}, \code{'median'}, \code{'meanFlag'}, \code{'medianFlag'} are
available for numerical variables. \code{'mode'}, \code{'modeFlag'}, \code{'newLevel'} are
available for factor variables. The word \code{'Flag'} in the methods indicates
whether a missing flag is added or not. The \code{'newLevel'} method means that
all missing values are replaced with a new level rather than imputing them
to another existing value.}

\item{splitMethod}{the splitting rule in LDATree growing process. For now,
\code{'LDscores'} is the only available option.}

\item{pruneMethod}{the model selection method in the LDATree growing process,
which controls the size of the tree. By default, it's set to \code{'none'},
which applies a direct stopping rule. Alternatively, \code{'CV'} uses the
alpha-pruning process from CART. Although \code{'CV'} is often more accurate, it
can be slower, especially with large datasets.}

\item{numberOfPruning}{controls the number of cross-validation in the
pruning. It is 10 by default.}

\item{maxTreeLevel}{controls the largest tree size possible for either a
direct-stopping tree or a CV-pruned tree. Adding one extra level (depth)
introduces an additional layer of nodes at the bottom of the current tree.
e.g., when the maximum level is 1 (or 2), the maximum tree size is 3 (or
7).}

\item{minNodeSize}{controls the minimum node size. Think carefully before
changing this value. Setting a large number might result in early stopping
and reduced accuracy. By default, it's set to one plus the number of
classes in the response variable.}

\item{verbose}{a logical. If TRUE, the function provides additional
diagnostic messages or detailed output about its progress or internal
workings. Default is FALSE, where the function runs silently without
additional output.}
}
\value{
An object of class \code{Treee} containing the following components:
\itemize{
\item \code{formula}: the formula passed to the \code{\link[=Treee]{Treee()}}
\item \code{treee}: a list of all the tree nodes, and each node is an object of class \code{TreeeNode}.
\item \code{missingMethod}: the missingMethod passed to the \code{\link[=Treee]{Treee()}}

An object of class \code{TreeeNode} containing the following components:
\item \code{currentIndex}: the node index of the current node
\item \code{currentLevel}: the level of the current node in the tree
\item \code{idxRow}, \code{idxCol}: the row and column indices showing which portion of data is used in the current node
\item \code{currentLoss}: the training error (number of misclassified sample) of the current node
\item \code{accuracy}: the training accuracy of the current node
\item \code{proportions}: shows the observed frequency for each class
\item \code{parent}: the node index of its parent
\item \code{children}: the node indices of its direct children (not including its children's children)
\item \code{misReference}: a data frame, serves as the reference for missing value imputation
\item \code{splitCut}: the cut point of the split
\item \code{nodeModel}: one of \code{'mode'} or \code{'LDA'}. It shows the type of predictive model fitted in the current node
\item \code{nodePredict}: the fitted predictive model in the current node. It is an object of class \code{ldaGSVD} if LDA is fitted. If \code{nodeModel = 'mode'}, then it is a vector of length one, showing the plurality class.
\item \code{offsprings}: (available only if \code{pruneMethod = 'CV'}) showing all terminal descendant nodes of the current node
\item \code{offspringLoss}: (available only if \code{pruneMethod = 'CV'}) sum of the \code{currentLoss} of the \code{offsprings} of the current node
\item \code{alpha}: (available only if \code{pruneMethod = 'CV'}) the alpha in alpha-pruning from CART
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Fit an LDATree model.
}
\details{
Unlike other classification trees, LDATree integrates LDA throughout the
entire tree-growing process. Here is a breakdown of its distinctive features:
\itemize{
\item The tree searches for the best binary split based on sample quantiles of the first linear discriminant score.
\item An LDA/GSVD model is fitted for each terminal node (For more details, refer to \code{\link[=ldaGSVD]{ldaGSVD()}}).
\item Missing values can be imputed using the mean, median, or mode, with optional missing flags available.
\item By default, the tree employs a direct-stopping rule. However, cross-validation using the alpha-pruning from CART is also provided.
}
}
\examples{
fit <- Treee(Species~., data = iris)
# Use cross-validation to prune the tree
fitCV <- Treee(Species~., data = iris, pruneMethod = "CV")
# prediction
predict(fit,iris)
# plot the overall tree
plot(fit)
# plot a certain node
plot(fit, iris, node = 7)
}
