% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kernel.density.R
\name{graph.kd}
\alias{graph.kd}
\title{Find weights based on kernel density on the graph.}
\usage{
graph.kd(relate.matrix, network.graph, smoothing.normalize = c("one",
  "squareM", "none"))
}
\arguments{
\item{relate.matrix}{The matrix returned by lascouting.}

\item{network.graph}{The igraph object representing the gene network.}

\item{smoothing.normalize}{Different ways to normalize the result.}
}
\value{
A matrix representing the weights calculated using kernel density for each gene. Each row is an ego gene, columns
are the weights of potential scouting genes for the gene.
}
\description{
There are three common ways to invoke \code{graph.kd}:
\itemize{
  \item \code{graph.kd(relate_matrix, graph, smoothing.normalize=c('one'))}
  \item \code{graph.kd(relate_matrix, graph, smoothing.normalize=c('squareM'))}
  \item \code{graph.kd(relate_matrix, graph, smoothing.normalize=c('none'))}
  }
The first method is used when the total weight of all genes z is set to 'one'.
In this way, those genes surrounded by more genes z will not take advantages over those surrounded by fewer genes.
In contrast, the second method takes the number of genes around into consideration, the result of the first method will
multiply the square of the number of genes around.
The third method does not normalize the data. Thus genes with more neighbors are more likely to receive higher weights.
}
\examples{
\dontrun{
relate.matrix <- lascouting(g,m,k=2,n.cores=4)
graph.kd(relate.matrix,g,smoothing.normalize = "one")}
}

