% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{Summary}
\alias{Summary}
\alias{summary.L1cent}
\alias{summary.L1centLOC}
\alias{summary.L1centNB}
\alias{summary.L1centEDGE}
\alias{print.summaryL1centrality}
\title{Summary Methods in the L1centrality Package}
\usage{
\method{summary}{L1cent}(object, ...)

\method{summary}{L1centLOC}(object, ...)

\method{summary}{L1centNB}(object, ...)

\method{summary}{L1centEDGE}(object, ...)

\method{print}{summaryL1centrality}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{An object used to select a method.}

\item{...}{Further arguments passed to or from other methods. This argument
is ignored here.}

\item{x}{A \code{summaryL1centrality} object, obtained as a result of the function
\code{summary.L1cent()} or \code{summary.L1centLOC()} or \code{summary.L1centNB()}.}

\item{digits}{Minimal number of significant digits, see \code{\link[=print.default]{print.default()}}.}
}
\value{
For the methods for the class \code{L1cent}, \code{L1centLOC}, and \code{L1centNB},
object of class \code{summaryL1centrality} is returned. It is a summary of the
prominence values with the five-number summary, mean, and the Gini
coefficient.

For the method for the class \code{L1centEDGE}, number of local medians at each
locality level \code{alpha} is returned.
}
\description{
\code{summary()} methods for the classes in the \code{L1centrality} package.
}
\examples{
summary(L1cent(MCUmovie))
summary(L1centLOC(MCUmovie, alpha = c(5/32, 10/32)))
head(summary(L1centNB(MCUmovie)))
summary(L1centEDGE(MCUmovie, alpha = c(5/32, 10/32)))
}
\references{
S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
\emph{arXiv preprint arXiv:2404.13233}, 2024.
}
\seealso{
\code{\link[=L1cent]{L1cent()}}, \code{\link[=L1centLOC]{L1centLOC()}}, \code{\link[=L1centNB]{L1centNB()}}, \code{\link[=L1centEDGE]{L1centEDGE()}}, \link{Heterogeneity}.
}
