/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class DisjunctionMaxQuery
extends Query {
    private ArrayList disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection disjuncts, float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    public void add(Query query) {
        this.disjuncts.add(query);
    }

    public void add(Collection disjuncts) {
        this.disjuncts.addAll(disjuncts);
    }

    public Iterator iterator() {
        return this.disjuncts.iterator();
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new DisjunctionMaxWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        int numDisjunctions = this.disjuncts.size();
        if (numDisjunctions == 1) {
            Query singleton = (Query)this.disjuncts.get(0);
            Query result = singleton.rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (result == singleton) {
                    result = (Query)result.clone();
                }
                result.setBoost(this.getBoost() * result.getBoost());
            }
            return result;
        }
        DisjunctionMaxQuery clone = null;
        for (int i = 0; i < numDisjunctions; ++i) {
            Query clause = (Query)this.disjuncts.get(i);
            Query rewrite = clause.rewrite(reader);
            if (rewrite == clause) continue;
            if (clone == null) {
                clone = (DisjunctionMaxQuery)this.clone();
            }
            clone.disjuncts.set(i, rewrite);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public Object clone() {
        DisjunctionMaxQuery clone = (DisjunctionMaxQuery)super.clone();
        clone.disjuncts = (ArrayList)this.disjuncts.clone();
        return clone;
    }

    public void extractTerms(Set terms) {
        Iterator iter = this.disjuncts.iterator();
        while (iter.hasNext()) {
            ((Query)iter.next()).extractTerms(terms);
        }
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int numDisjunctions = this.disjuncts.size();
        for (int i = 0; i < numDisjunctions; ++i) {
            Query subquery = (Query)this.disjuncts.get(i);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i == numDisjunctions - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append("^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return this.getBoost() == other.getBoost() && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected Similarity similarity;
        protected ArrayList weights = new ArrayList();

        public DisjunctionMaxWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
            Iterator iter = DisjunctionMaxQuery.this.disjuncts.iterator();
            while (iter.hasNext()) {
                this.weights.add(((Query)iter.next()).createWeight(searcher));
            }
        }

        public Query getQuery() {
            return DisjunctionMaxQuery.this;
        }

        public float getValue() {
            return DisjunctionMaxQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float max = 0.0f;
            float sum = 0.0f;
            Iterator iter = this.weights.iterator();
            while (iter.hasNext()) {
                float sub = ((Weight)iter.next()).sumOfSquaredWeights();
                sum += sub;
                max = Math.max(max, sub);
            }
            float boost = DisjunctionMaxQuery.this.getBoost();
            return ((sum - max) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max) * boost * boost;
        }

        public void normalize(float norm) {
            norm *= DisjunctionMaxQuery.this.getBoost();
            Iterator iter = this.weights.iterator();
            while (iter.hasNext()) {
                ((Weight)iter.next()).normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer[] scorers = new Scorer[this.weights.size()];
            int idx = 0;
            Iterator iter = this.weights.iterator();
            while (iter.hasNext()) {
                Weight w = (Weight)iter.next();
                Scorer subScorer = w.scorer(reader, true, false);
                if (subScorer == null || subScorer.nextDoc() == Integer.MAX_VALUE) continue;
                scorers[idx++] = subScorer;
            }
            if (idx == 0) {
                return null;
            }
            DisjunctionMaxScorer result = new DisjunctionMaxScorer(DisjunctionMaxQuery.this.tieBreakerMultiplier, this.similarity, scorers, idx);
            return result;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            if (DisjunctionMaxQuery.this.disjuncts.size() == 1) {
                return ((Weight)this.weights.get(0)).explain(reader, doc);
            }
            ComplexExplanation result = new ComplexExplanation();
            float max = 0.0f;
            float sum = 0.0f;
            result.setDescription(DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:");
            Iterator iter = this.weights.iterator();
            while (iter.hasNext()) {
                Explanation e = ((Weight)iter.next()).explain(reader, doc);
                if (!e.isMatch()) continue;
                result.setMatch(Boolean.TRUE);
                result.addDetail(e);
                sum += e.getValue();
                max = Math.max(max, e.getValue());
            }
            result.setValue(max + (sum - max) * DisjunctionMaxQuery.this.tieBreakerMultiplier);
            return result;
        }
    }
}

