% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDerivatives.R
\name{plot.derivatives}
\alias{plot.derivatives}
\title{Plot derivatives of a kspm object}
\usage{
\method{plot}{derivatives}(x, subset = NULL, xlab = NULL,
  ylab = NULL, ...)
}
\arguments{
\item{x}{an object of class "derivatives", usually, a result of a call to \code{derivatives}.}

\item{subset}{if a subset of the plots is required, specify the names of the variable for which plot of derivatives is required.}

\item{xlab}{x label}

\item{ylab}{y label}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Plot of derivatives for kernel part of a kspm model.
}
\details{
X axis represents the raw data used as input in kernel part of the model. Y axis represents the pointwise derivative values i.e. the derivatives of fitted value according to the variable of interest.
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0))
plot(derivatives(fit))

}
\references{
Kim, Choongrak, Byeong U. Park, and Woochul Kim. "Influence diagnostics in semiparametric regression models." Statistics and probability letters 60.1 (2002): 49:58.
}
\seealso{
\link{derivatives}
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
