% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRhsip.R
\name{LRhsip}
\alias{LRhsip}
\title{LR in half-sibling identification with the identical parent participated}
\usage{
LRhsip(A, B, P, af, rare = NULL, allelename = FALSE, phi = 0.5)
}
\arguments{
\item{A}{Genotype data of the first sibling, should be data.frame with 2 columns and ss rows, where ss stand for sample size;}

\item{B}{Genotype data of the second sibling, with the same form with \code{A}}

\item{P}{Genotype data of the identical parent of \code{A} and \code{B}, with the same form with them}

\item{af}{name of allele frequency matrix, a data.frame of 1 column containing frequencies with allele names being row names}

\item{rare}{frequency of rare allele on the locus}

\item{allelename}{if TRUE, the input genotype data would be regarded as allelenames, otherwise, the position in the af matrix}

\item{phi}{kinship coefficient of the other parents of the two siblings under Hp, with default of 1/2, i.e, being identical or MZ}
}
\value{
a data frame with one column and ss rows, containing log10 value of the CLR of each case
}
\description{
LR when a pair of siblings and one of their identical parent participated, Hp and Hd of which being "the other parents of the two siblings being specific related" and "the other parents of them being unrelated". Inbreeding factors are not taken into consideration.
}
\details{
Mutation might be found between P with A or B, if so, LR would be output as 1-phi, which can be further optimized in the future version.
}
\examples{
# Simulate 10000 groups of A/B/P where A is full sibiling of B
pedi <- data.frame(Person=c("F","M","A","B"),
Father=c("RI","RI","F","F"),
Mother=c("RI","RI","M","M"))
Genotype=pedisimu(af = FortytwoSTR$afmatrix[[1]],ss = 10000,pedi = pedi)
#Calculation
LR_1=LRhsip(A=Genotype[,5:6],B=Genotype[,7:8],P=Genotype[,3:4],
af = FortytwoSTR$afmatrix[[1]],rare=FortytwoSTR$rare[1])

# Simulate 10000 groups of A/B/P where A is half sibling of B, i.e., the true phi=0
pedi <- data.frame(Person=c("M","A","B"),
Father=c("RI","RI","RI"),
Mother=c("RI","M","M"))
Genotype=pedisimu(af = FortytwoSTR$afmatrix[[1]],ss = 10000,pedi = pedi)
#Calculation
LR_2=LRhsip(A=Genotype[,3:4],B=Genotype[,5:6],P=Genotype[,1:2],
af = FortytwoSTR$afmatrix[[1]],rare=FortytwoSTR$rare[1])

}
