% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shutdown_request.R
\name{shutdown_request}
\alias{shutdown_request}
\title{Kernel Info Request Handler}
\usage{
shutdown_request(request_msg)
}
\arguments{
\item{request_msg}{A list passed in from \code{doRequest} representing the
deserialized \code{shutdown_request} message JSON.}
}
\value{
A list having names \code{msg_type} and \code{content}. The
  \code{msg_type} is \code{shutdown_reply}, which corresponds
  to the \code{shutdown_request} message. The \code{content} field
  complies with the Jupyter wire message protocol specification
  for \code{shutdown_reply} messages.
}
\description{
Response to the \code{shutdown_request} Message Type
}
\examples{
\dontrun{
  request_msg <- list(restart=FALSE)
  shutdown_request(request_msg)
}

}
\references{
\url{http://jupyter-client.readthedocs.io/en/latest/messaging.html#kernel-shutdown}
}
\author{
Spencer Aiello
}
