test_that("flash year 2015", {

  skip_on_cran() # due to risk of external resources failing

  year_link <- "https://flashresults.com/2015results.htm"

  df_test <- flash_year_links(year_link)

  df_standard <- data.frame(
    Meet = c(
      "ParaPan American Games",
      "AAU Jr. Olympic Games",
      "Pan American Games",
      "World University Games",
      "USATF Outoor Championships",
      "New Balance High School Nationals",
      "NCAA Track & Field Championships",
      "NCAA East Preliminary",
      "ACC Championships",
      "Big South Championships",
      "Virginia Grand Prix",
      "Duke Twilight",
      "Atlantic 10 Championships",
      "Dogwood Classic",
      "Arkansas Twilight",
      "Penn Relays",
      "Virginia Challenge",
      "Arkansas Combined",
      "Duke Invitational",
      "John McDonnell Invitational",
      "HPU VertKlasse Meeting",
      "Raleigh Relays",
      "Arkansas Spring Invitational",
      "Virginia Cup",
      "49er Classic",
      "Wake Forest Open",
      "NCAA Div I Championships",
      "USATF Indoor Championships",
      "ACC Championships",
      "Arkansas Open",
      "Atlantic 10 Championships",
      "Virginia Tech Challenge",
      "Tyson Invitational",
      "New Balance Indoor Grand Prix",
      "Texas A&M Aggie Invitational",
      "Doc Hale - VT Elite Meet",
      "Razorback Invitational",
      "Hokie Invitational",
      "Texas A&M Quadrangular Meet",
      "Texas A&M Team Invitational",
      "Texas A&M 13 Team Invitational",
      "Virginia Tech Invitational",
      "Arkansas HS Invitational",
      "Arkansas -v- Texas",
      "Texas A&M HS Classic",
      "Arkansas Invitational",
      "Reveille Invitational",
      "Central American & Caribbean Games"
    ),
    Meet_Date = c(
      "August 10-14 2015",
      "August 1-8 2015",
      "July 21-25 2015",
      "July 8-12 2015",
      "June 25-28 2015",
      "June 19-21 2015",
      "June 10-13 2015",
      "May 28-30 2015",
      "May 14-16 2015",
      "May 14-16 2015",
      "May 8 2015",
      "May 6-7 2015",
      "May 2-3 2015",
      "May 1-2 2015",
      "May 1 2015",
      "April 21-25 2015",
      "April 17-18 2015",
      "April 15-16 2015",
      "April 11 2015",
      "April 10-11 2015",
      "April 3-4 2015",
      "March 27-28 2015",
      "March 27-28 2015",
      "March 21 2015",
      "March 19-21 2015",
      "March 20-21 2015",
      "March 13-14 2015",
      "February 27-March 1 2015",
      "February 26-28 2015",
      "February 21 2015",
      "February 21-22 2015",
      "February 20-21 2015",
      "February 13-14 2015",
      "February 7 2015",
      "February 6-7 2015",
      "February 6-7 2015",
      "January 30-31 2015",
      "January 23-24 2015",
      "January 24 2015",
      "January 16-17 2015",
      "January 16 2015",
      "January 16-17 2015",
      "January 17 2015",
      "January 16 2015",
      "January 9-10 2015",
      "January 9 2015",
      "December 13 2015",
      "November 24-28 2015"
    ),
    Location = c(
      "CIBC Pan Am Athletics Stadium - Toronto, Canada",
      "Dick Price Stadium - Norfolk, Virginia",
      "CIBC Pan Am Athletics Stadium - Toronto, Canada",
      "Gwangju World Cup Stadium - Gwangju, Korea",
      "Hayward Field - Eugene, OR",
      "Aggie Stadium, NC A&T University - Greensboro, NC",
      "Hayward Field - Eugene, OR",
      "Hodges Stadium - Jacksonville, FL",
      "Mike Long Track - Tallahassee, FL",
      "Dick Vert Stadium - High Point, NC",
      "Lannigan Field - Charlottesville, VA",
      "Morris Williams Stadium - Durham, NC",
      "George Mason Stadium - Fairfax, VA",
      "Lannigan Field - Charlottesville, VA",
      "John McDonnell Field - Fayetteville, AR",
      "Franklin Field - Philadelphia, PA",
      "Lannigan Field - Charlottesville, VA",
      "John McDonnell Field - Fayetteville, AR",
      "Morris Williams Stadium - Durham, NC",
      "John McDonnell Field - Fayetteville, AR",
      "Dick Vert Stadium - High Point, NC",
      "NC State - Raleigh, NC",
      "John McDonnell Field - Fayetteville, AR",
      "Lannigan Field - Charlottesville, VA",
      "Belk Track & Field Center - Charlotte, NC",
      "Kentner Stadium - Winston-Salem, NC",
      "Randal Tyson Track Center - Fayetteville, AR",
      "March 1 - Reggie Lewis Center - Roxbury, MA",
      "Rector Field House - Blacksburg, VA",
      "Randal Tyson Track Center - Fayetteville, AR",
      "Mackal Field House - Kingston, RI",
      "Rector Field House - Blacksburg, VA",
      "Randal Tyson Track Center - Fayetteville, AR",
      "Reggie Lewis Center - Roxbury, MA",
      "Gilliam Indoor Track Stadium - College Station, TX",
      "Rector Field House - Blacksburg, VA",
      "Randal Tyson Track Center - Fayetteville, AR",
      "Rector Field House - Blacksburg, VA",
      "Gilliam Indoor Track Stadium - College Station, TX",
      "Gilliam Indoor Track Stadium - College Station, TX",
      "Gilliam Indoor Track Stadium - College Station, TX",
      "Rector Field House - Blacksburg, VA",
      "Randal Tyson Track Center - Fayetteville, AR",
      "Randal Tyson Track Center - Fayetteville, AR",
      "Gilliam Indoor Track Stadium - College Station, TX",
      "Randal Tyson Track Center - Fayetteville, AR",
      "Gilliam Indoor Track Stadium - College Station, TX",
      "Heriberto Jara Corona Stadium - Xalapa, MEX"
    ),
    Meet_link = c(
      "http://results.toronto2015.org/PRS/en/athletics/schedule-and-results.htm",
      "http://image2.aausports.org/sports/athletics/results/2015/jogames/live/",
      "http://results.toronto2015.org/IRS/en/athletics/schedule-and-results.htm",
      "http://www.gwangju2015.com/IRS/eng/zz/engzz_athletics_sport_overview.htm",
      "https://flashresults.com/2015_Meets/Outdoor/06-25_USATF/",
      "https://flashresults.com/2015_Meets/Outdoor/06-19_NBHS/",
      "https://flashresults.com/2015_Meets/Outdoor/06-10_NCAA/",
      "https://flashresults.com/2015_Meets/Outdoor/05-28_NCAAEast/",
      "https://flashresults.com/2015_Meets/Outdoor/05-14_ACC/",
      "https://flashresults.com/2015_Meets/Outdoor/05-14_BigSouth/",
      "https://flashresults.com/2015_Meets/Outdoor/05-08_UVAGrandPrix/",
      "https://flashresults.com/2015_Meets/Outdoor/05-06_DukeTwilight/",
      "https://flashresults.com/2015_Meets/Outdoor/05_02-A10/",
      "https://flashresults.com/2015_Meets/Outdoor/05-01_Dogwood/",
      "https://flashresults.com/2015_Meets/Outdoor/05-01_ArkTwilight/",
      "http://pennrelaysonline.com/Results/schedule.aspx",
      "https://flashresults.com/2015_Meets/Outdoor/04-17_VirginiaChallenge/",
      "https://flashresults.com/2015_Meets/Outdoor/04-15-15_ArkCombined/",
      "https://flashresults.com/2015_Meets/Outdoor/04-11_DukeInvitational/",
      "https://flashresults.com/2015_Meets/Outdoor/04-10_McDonnell/",
      "https://flashresults.com/2015_Meets/Outdoor/04-03_VertKlasse/",
      "https://flashresults.com/2015_Meets/Outdoor/03-27_RaleighRelays/",
      "https://flashresults.com/2015_Meets/Outdoor/03-27_ArkSpringInv/",
      "https://flashresults.com/2015_Meets/Outdoor/03-21_VirginiaCup/",
      "https://flashresults.com/2015_Meets/Outdoor/03-19_49erClassic/",
      "https://flashresults.com/2015_Meets/Outdoor/03-20_WakeOpen/",
      "https://flashresults.com/2015_Meets/Indoor/03-13_NCAA/",
      "https://flashresults.com/2015_Meets/Indoor/02-27_USA/",
      "https://flashresults.com/2015_Meets/Indoor/02-26_ACC/",
      "https://flashresults.com/2015_Meets/Indoor/02-21_ArkOpen/",
      "https://flashresults.com/2015_Meets/Indoor/02-20_A10/",
      "https://flashresults.com/2015_Meets/Indoor/02-20_VTChallenge/",
      "https://flashresults.com/2015_Meets/Indoor/02-13_Tyson/",
      "https://flashresults.com/2015_Meets/Indoor/02-07_NBGP/",
      "https://flashresults.com/2015_Meets/Indoor/02-06_TamuAggie/",
      "https://flashresults.com/2015_Meets/Indoor/02-06_VTDocHale/",
      "http://www.flashresults.com/2015_Meets/Indoor/01-30_Razorback/",
      "https://flashresults.com/2015_Meets/Indoor/01-23_VTHokie/",
      "https://flashresults.com/2015_Meets/Indoor/01-24_TamuQuadrangular/",
      "https://flashresults.com/2015_Meets/Indoor/01-17_TamuTeam/",
      "https://flashresults.com/2015_Meets/Indoor/01-16_Tamu13Team/",
      "https://flashresults.com/2015_Meets/Indoor/01-16_VTInvite/",
      "http://www.flashresults.com/2015_Meets/Indoor/01-17_arkhs/",
      "http://www.flashresults.com/2015_Meets/Indoor/01-16-ArkTex/",
      "https://flashresults.com/2015_Meets/Indoor/01-09_TamuHS/",
      "http://www.flashresults.com/2015_Meets/Indoor/01-09_arktri/",
      "https://flashresults.com/2015_Meets/Indoor/12-13_Reveille/",
      "http://info.veracruz2014.mx/info/eng/zz/engzz_athletics_sport_overview.htm"
    )
  )

  expect_equivalent(df_standard, df_test)

})

# testthat::test_file("tests/testthat/test-flash_year_links.R")
