% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.diffeek}
\alias{plot.diffeek}
\title{plot diffeek result specified by user input}
\usage{
\method{plot}{diffeek}(x, type = "task", index = NULL,
  hastitle = TRUE, ...)
}
\arguments{
\item{x}{output generated from diffee function (diffee class)}

\item{type}{type of graph. There are two options:
\itemize{
\item "task" (difference graph)
\item "neighbour" (zoom into nodes in the difference graph specified further by parameter
\strong{"index"} (node id)
}}

\item{index}{determines which node(s) to zoom into when parameter \strong{"type"} is \strong{"neighbour"}.
This parameter could either be an integer or vector of integers representing node ids}

\item{hastitle}{determines whether the graph title is displayed or not (TRUE to display / FALSE to hide)}

\item{...}{extra parameters passed to  \code{\link{plot.igraph}}
(zoom into one node or multiple nodes)}
}
\value{
a plot of the difference graph from diffeek result specified by user input
}
\description{
This function can plot diffeek result
}
\details{
when only the diffeek result is provided, the function will plot all graphs with default numeric labels.
Users can specify multiple subID to zoom in multiple nodes.
Each graph will include a descriptive title.
}
\examples{
library(JointNets)
data(exampleData)
result = diffeek(exampleData[[1]], exampleData[[2]],
W = matrix(1,20,20), g = rep(0,20),epsilon = 0.2,
lambda = 0.4,covType = "cov")
plot(result)
}
\author{
Beilun Wang, Zhaoyang Wang (Author), Zhaoyang Wang (maintainer) \email{zw4dn@virginia.edu}
}
