/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.ClassList;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import org.omegahat.Environment.Tools.ClassList.ArchiveClassList;
import org.omegahat.Environment.Tools.ClassList.ClassList;
import org.omegahat.Environment.Tools.ClassList.ClassLocatorInt;
import org.omegahat.Environment.Tools.ClassList.ObjectList;
import org.omegahat.Environment.Tools.ClassList.PackageClassList;

public class GroupedClassLocator
extends ClassList
implements ClassLocatorInt {
    public GroupedClassLocator() {
    }

    public GroupedClassLocator(Vector vector2) {
        int n = 0;
        while (n < vector2.size()) {
            Object e = vector2.elementAt(n);
            if (e instanceof String) {
                this.add((String)e);
            } else if (e instanceof ClassList) {
                this.add(e, ((ClassList)e).file());
            }
            ++n;
        }
    }

    public GroupedClassLocator(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
    }

    public Object add(String string) {
        if (string == null || string == "") {
            return null;
        }
        File file = new File(string);
        if (this.checkIsArchive(string)) {
            this.file(file);
            this.archive(true);
            this.lookupArchive(new File(string));
            this.archive(false);
        } else if (this.isPackage(string)) {
            this.add(string, true);
        } else if (file.isDirectory()) {
            this.file(file);
            this.lookupDirectory(file);
        } else {
            super.add(file);
        }
        this.file = null;
        return null;
    }

    public Object add(String string, boolean bl) {
        Object object = null;
        if (bl) {
            PackageClassList packageClassList = new PackageClassList(string);
            packageClassList.entries();
            int n = 0;
            while (n < packageClassList.size()) {
                ClassList classList = (ClassList)packageClassList.elementAt(n);
                this.add(classList, classList.file());
                ++n;
            }
            this.add(packageClassList, packageClassList.realDirectory().toString());
        } else {
            object = this.add(string);
        }
        return object;
    }

    public Vector findClasses(String string, Vector vector2) {
        Object object = null;
        String string2 = null;
        Enumeration enumeration = this.entries().elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof ZipEntry) {
                string2 = ((ZipEntry)object).getName();
            } else if (object instanceof File) {
                string2 = ((File)object).toString();
            } else if (object instanceof String) {
                string2 = (String)object;
            } else {
                System.out.println("Object not expected: " + object.getClass().getName());
                new Exception().printStackTrace();
                continue;
            }
            if (!this.matchesClassName(string, string2) || vector2.contains(object)) continue;
            vector2.add(object);
        }
        return vector2;
    }

    public boolean isPackage(String string) {
        return string.endsWith("/..");
    }

    public ObjectList newSubList() {
        ClassList classList = null;
        classList = this.isArchive() ? new ArchiveClassList() : new ClassList();
        return classList;
    }
}

