% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_japan_unemployment.R
\name{get_japan_unemployment}
\alias{get_japan_unemployment}
\title{Get Japan's Unemployment Rate from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SL.UEM.TOTL.ZS}
}
\usage{
get_japan_unemployment()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Unemployment, total (% of total labor force)")
  \item \code{country}: Country name ("Japan")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Unemployment rate as percentage in numeric form
}
}
\description{
Retrieves Japan's Unemployment, total (% of total labor force)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SL.UEM.TOTL.ZS}.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection. The data is retrieved in real time from the World Bank API.
}
\examples{
if (interactive()) {
  get_japan_unemployment()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
