% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{smd}
\alias{smd}
\title{Calculate Standardized Mean Difference (SMD)}
\usage{
smd(x, g, index = c("all", "1", "2"))
}
\arguments{
\item{x}{A continuous variable}

\item{g}{A grouping variable, with two levels}

\item{index}{A character string: \dQuote{all} uses pooled variance,
\dQuote{1} uses the first factor level variance,
\dQuote{2} uses the second factor level variance.}
}
\value{
The standardized mean difference.
}
\description{
Simple function to calculate effect sizes for mean differences.
}
\examples{
smd(mtcars$mpg, mtcars$am)
smd(mtcars$mpg, mtcars$am, "all")
smd(mtcars$mpg, mtcars$am, "1")
smd(mtcars$mpg, mtcars$am, "2")

smd(mtcars$hp, mtcars$vs)

d <- data.table::as.data.table(mtcars)
d[, smd(mpg, vs)]
rm(d)
}
