% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdiff.R
\name{cdiff}
\alias{cdiff}
\title{Compute a second order circular differencing matrix}
\usage{
cdiff(n)
}
\arguments{
\item{n}{number of rows (and columns) of the square differencing matrix.}
}
\value{
A square matrix with \code{n} rows and columns.
}
\description{
Compute difference matrix used for circular penalities.
}
\examples{
# Compare standard and circular differencing matrix
n = 8
D1 = diff(diag(n), diff = 2)
D2 = cdiff(n)
oldpar = par(no.readonly = TRUE)
on.exit(par(oldpar))
par(mfrow = c(1, 2))
image(t(D1))
title('Linear differencing matrix')
image(t(D2))
title('Circular differencing matrix')


}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers
}
