/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.robjects;

import java.text.DecimalFormat;
import java.util.Vector;

public class RModel {
    private final Vector info = new Vector();
    private final DecimalFormat dformat = new DecimalFormat("#0.00");
    private Double rsquared;
    private Double deviance;
    private Double aic;
    private Integer df = null;
    private String family = null;
    private String call = null;
    private String data = null;
    private String type = "model";
    private String name;

    public RModel(String name, String type) {
        this.name = name;
        if (type != null) {
            this.type = type;
        }
    }

    public String getTypeName() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getCall() {
        return this.call;
    }

    public void setCall(String call) {
        this.call = call;
    }

    public String getToolTip() {
        return "<html><pre>" + this.call + "</pre></html>";
    }

    public void setRsquared(double r) {
        this.rsquared = new Double(this.dformat.format(r).replace(',', '.'));
    }

    public void setDeviance(double d) {
        this.deviance = new Double(this.dformat.format(d).replace(',', '.'));
    }

    public void setDf(int df) {
        this.df = new Integer(df);
    }

    public void setAic(double a) {
        this.aic = new Double(this.dformat.format(a).replace(',', '.'));
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String f) {
        this.family = f;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String d) {
        this.data = d;
    }

    public Vector getInfo() {
        if (this.info.size() == 0) {
            this.info.add(this.getName());
            this.info.add(this.getData());
            this.info.add(this.getTypeName());
            this.info.add(this.family);
            this.info.add(this.df);
            this.info.add(this.rsquared);
            this.info.add(this.aic);
            this.info.add(this.deviance);
        }
        return this.info;
    }

    public String toString() {
        return this.getName() + " (model)";
    }
}

