/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.rosuda.JGR.JGRConsole;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.ConsoleSync;
import org.rosuda.JGR.toolkit.JGRListener;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.SplashScreen;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.util.Global;
import org.rosuda.util.Platform;

public class JGR {
    public static final String VERSION = "1.6-1";
    public static final String TITLE = "JGR";
    public static final String SUBTITLE = "Java Gui for R";
    public static final String DEVELTIME = "2003 - 2008";
    public static final String INSTITUTION = "RoSuDa, Univ. Augsburg";
    public static final String AUTHOR1 = "Markus Helbig";
    public static final String AUTHOR2 = "Simon Urbanek";
    public static final String WEBSITE = "http://www.rosuda.org";
    public static final String SPLASH = "jgrsplash.jpg";
    public static JGRConsole MAINRCONSOLE = null;
    public static Vector RHISTORY = null;
    public static String RHOME = null;
    public static String[] RLIBS = null;
    public static Rengine R = null;
    public static ConsoleSync rSync = new ConsoleSync();
    public static Vector DATA = new Vector();
    public static Vector MODELS = new Vector();
    public static Vector OTHERS = new Vector();
    public static Vector FUNCTIONS = new Vector();
    public static Vector OBJECTS = new Vector();
    public static Vector KEYWORDS = new Vector();
    public static Vector KEYWORDS_OBJECTS = new Vector();
    public static boolean STARTED = false;
    private static JGRListener jgrlistener = null;
    public static SplashScreen splash;
    private static String[] rargs;
    private static boolean JGRmain;
    private static String tempWD;

    public JGR() {
        SVar.int_NA = Integer.MIN_VALUE;
        Object object = new Object();
        JGRPackageManager.neededPackages.put("base", object);
        JGRPackageManager.neededPackages.put("graphics", object);
        JGRPackageManager.neededPackages.put("grDevices", object);
        JGRPackageManager.neededPackages.put("utils", object);
        JGRPackageManager.neededPackages.put("methods", object);
        JGRPackageManager.neededPackages.put("stats", object);
        JGRPackageManager.neededPackages.put("datasets", object);
        JGRPackageManager.neededPackages.put(TITLE, object);
        JGRPackageManager.neededPackages.put("rJava", object);
        JGRPackageManager.neededPackages.put("JavaGD", object);
        JGRPackageManager.neededPackages.put("iplots", object);
        Platform.initPlatform((String)"org.rosuda.JGR.toolkit.");
        JGRPrefs.initialize();
        splash = new SplashScreen();
        splash.start();
        JGR.readHistory();
        MAINRCONSOLE = new JGRConsole();
        MAINRCONSOLE.setWorking(true);
        splash.toFront();
        if (System.getProperty("os.name").startsWith("Window")) {
            splash.stop();
            JGRPrefs.isWindows = true;
        }
        try {
            System.loadLibrary("jri");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = "all environment variables (PATH, LD_LIBRARY_PATH, etc.) are setup properly (see supplied script)";
            String string2 = "libjri.so";
            if (System.getProperty("os.name").startsWith("Window")) {
                string = "you start JGR by double-clicking the JGR.exe program";
                string2 = "jri.dll";
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                string = "you start JGR by double-clicking the JGR application";
                string2 = "libjri.jnilib";
            }
            JOptionPane.showMessageDialog(null, "Cannot find Java/R Interface (JRI) library (" + string2 + ").\nPlease make sure " + string + ".", "Cannot find JRI library", 0);
            System.err.println("Cannot find JRI native library!\n");
            unsatisfiedLinkError.printStackTrace();
            System.exit(1);
        }
        if (!Rengine.versionCheck()) {
            JOptionPane.showMessageDialog(null, "Java/R Interface (JRI) library doesn't match this JGR version.\nPlease update JGR and JRI to the latest version.", "Version Mismatch", 0);
            System.exit(2);
        }
        R = new Rengine(rargs, true, (RMainLoopCallbacks)MAINRCONSOLE);
        if (Global.DEBUG > 0) {
            System.out.println("Rengine created, waiting for R");
        }
        if (!R.waitForR()) {
            System.out.println("Cannot load R");
            System.exit(1);
        }
        JGRPackageManager.defaultPackages = RController.getDefaultPackages();
        R.assign(".$JGR", JGRPrefs.workingDirectory);
        R.eval("try({setwd(`.$JGR`); rm(`.$JGR`)},silent=T)");
        STARTED = true;
        if (!System.getProperty("os.name").startsWith("Win")) {
            splash.stop();
        }
        JGR.MAINRCONSOLE.end = JGR.MAINRCONSOLE.output.getText().length();
        if (R != null && STARTED) {
            MAINRCONSOLE.execute("library(JGR,warn.conflicts=FALSE)", false);
        }
        JGR.MAINRCONSOLE.input.requestFocus();
        new Refresher().run();
    }

    public static String exit() {
        int n = JOptionPane.showConfirmDialog(null, "Save workspace?", "Close JGR", 1, 3);
        if (n == 0) {
            JGR.writeHistory();
            JGRPrefs.writeCurrentPackagesWhenExit();
            return "y\n";
        }
        if (n == 1) {
            JGRPrefs.writeCurrentPackagesWhenExit();
            return "n\n";
        }
        return "c\n";
    }

    public static void addMenu(String string) {
        if (MAINRCONSOLE == null) {
            return;
        }
        EzMenuSwing.addMenu((JFrame)((Object)MAINRCONSOLE), (String)string);
    }

    public static void addMenuItem(String string, String string2, String string3) {
        if (MAINRCONSOLE == null) {
            return;
        }
        if (jgrlistener == null) {
            jgrlistener = new JGRListener();
        }
        EzMenuSwing.addJMenuItem((JFrame)((Object)MAINRCONSOLE), (String)string, (String)string2, (String)string3, (ActionListener)jgrlistener);
    }

    public static void addMenuSeparator(String string) {
        if (MAINRCONSOLE == null) {
            return;
        }
        EzMenuSwing.addMenuSeparator((JFrame)((Object)MAINRCONSOLE), (String)string);
    }

    public static void setRHome(String string) {
        RHOME = string;
    }

    public static void setRLibs(String string) {
        JGR.setRLibs(new String[]{string});
    }

    public static void setRLibs(String[] stringArray) {
        RLIBS = stringArray;
        for (int i = 0; i < RLIBS.length; ++i) {
            if (!RLIBS[i].startsWith("~")) continue;
            JGR.RLIBS[i] = RLIBS[i].replaceFirst("~", System.getProperty("user.home"));
        }
    }

    public static void setKeyWords(String string) {
        JGR.setKeyWords(new String[]{string});
    }

    public static void setKeyWords(String[] stringArray) {
        KEYWORDS.clear();
        Object object = new Object();
        for (int i = 0; i < stringArray.length; ++i) {
            KEYWORDS.add(stringArray[i]);
        }
    }

    public static void setObjects(String string) {
        JGR.setObjects(new String[]{string});
    }

    public static void setObjects(String[] stringArray) {
        OBJECTS.clear();
        KEYWORDS_OBJECTS.clear();
        Object object = new Object();
        for (int i = 0; i < stringArray.length; ++i) {
            KEYWORDS_OBJECTS.add(stringArray[i]);
            OBJECTS.add(stringArray[i]);
        }
    }

    public static void readHistory() {
        File file = null;
        try {
            tempWD = JGRPrefs.workingDirectory;
            file = new File(JGRPrefs.workingDirectory + File.separator + ".JGRhistory");
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                RHISTORY = new Vector();
                String string = null;
                while (bufferedReader.ready()) {
                    if (!(string = (string == null ? "" : string + "\n") + bufferedReader.readLine()).endsWith("#")) continue;
                    RHISTORY.add(string.substring(0, string.length() - 1));
                    string = null;
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public static void writeHistory() {
        File file = null;
        try {
            file = new File(tempWD + File.separator + ".JGRhistory");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Enumeration enumeration = RHISTORY.elements();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write(enumeration.nextElement().toString() + "#\n");
                bufferedWriter.flush();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
        }
    }

    public static boolean isJGRmain() {
        return JGRmain;
    }

    private void checkForMissingPkg() {
        try {
            String string = JGRPrefs.previousPackages;
            if (string == null) {
                return;
            }
            String string2 = RController.getCurrentPackages();
            if (string2 == null) {
                return;
            }
            Vector vector = new Vector();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken().toString().replaceFirst(",", ""));
            }
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector3.add(stringTokenizer.nextToken().toString().replaceFirst(",", ""));
            }
            for (int i = 0; i < vector2.size(); ++i) {
                vector3.remove(vector2.elementAt(i));
            }
            if (vector3.size() > 0) {
                new JGRPackageManager(vector3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        JGRmain = true;
        if (stringArray.length > 0) {
            object = new Vector();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("--debug")) {
                    Global.DEBUG = 1;
                    Rengine.DEBUG = 1;
                    System.out.println("JGR version 1.6-1");
                } else {
                    ((Vector)object).add(stringArray[i]);
                }
                if (stringArray[i].equals("--version")) {
                    System.out.println("JGR version 1.6-1");
                    System.exit(0);
                }
                if (!stringArray[i].equals("--help") && !stringArray[i].equals("-h")) continue;
                System.out.println("JGR version 1.6-1");
                System.out.println("\nOptions:");
                System.out.println("\n\t-h, --help\t Print short helpmessage and exit");
                System.out.println("\t--version\t Print version end exit");
                System.out.println("\t--debug\t Print more information about JGR's process");
                System.out.println("\nMost other R options are supported too");
                System.exit(0);
            }
            Object[] objectArray = ((Vector)object).toArray();
            if (objectArray.length > 0) {
                rargs = new String[objectArray.length + 1];
                for (int i = 0; i < rargs.length - 1; ++i) {
                    JGR.rargs[i] = objectArray[i].toString();
                }
                JGR.rargs[JGR.rargs.length - 1] = "--save";
            }
        }
        if (Global.DEBUG > 0) {
            for (int i = 0; i < rargs.length; ++i) {
                System.out.println(rargs[i]);
            }
        }
        object = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel((String)object);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            new JGR();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
        }
    }

    static {
        rargs = new String[]{"--save"};
        JGRmain = false;
    }

    class Refresher
    implements Runnable {
        public Refresher() {
            JGR.this.checkForMissingPkg();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(60000L);
                        REXP rEXP = R.idleEval("try(.refreshKeyWords(),silent=TRUE)");
                        String[] stringArray = null;
                        if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
                            JGR.setKeyWords(stringArray);
                        }
                        rEXP = R.idleEval("try(.refreshObjects(),silent=TRUE)");
                        stringArray = null;
                        if (rEXP == null || (stringArray = rEXP.asStringArray()) == null) continue;
                        JGR.setObjects(stringArray);
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    continue;
                }
                break;
            }
        }
    }
}

