% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_matrix_classes.R
\encoding{UTF-8}
\name{QR_matrix}
\alias{QR_matrix}
\alias{mQR_matrix}
\alias{is.QR_matrix}
\alias{is.mQR_matrix}
\title{Quality report objects}
\usage{
QR_matrix(modalities = NULL, values = NULL, score_formula = NULL)

mQR_matrix(x = list(), ...)

is.QR_matrix(x)

is.mQR_matrix(x)
}
\arguments{
\item{modalities}{a \code{data.frame} containing the output variables' modalities (Good, Bad, etc.)}

\item{values}{a \code{data.frame} containing the output variables' values (test p-values, test statistics, etc.) Therefore, the values data frame can contain more variables
than the data frame \code{modalities}.}

\item{score_formula}{the formula used to calculate the series score (if defined).}

\item{x}{a \code{\link{QR_matrix}} object, a \code{\link{mQR_matrix}} object or a list of \code{\link{QR_matrix}} objects.}

\item{...}{objects of the same type as \code{x}.}
}
\value{
\code{QR_matrix()} creates and returns a \code{\link{QR_matrix}} object.
\code{mQR_matrix()} creates and returns a \code{\link{mQR_matrix}} object (ie. a list of \code{\link{QR_matrix}} objects).
\code{is.QR_matrix()} and \code{is.mQR_matrix()} return Boolean values (\code{TRUE} or \code{FALSE}).
}
\description{
\code{mQR_matrix()} and \code{QR_matrix()} are creating one (or several) quality report. The function
\code{is.QR_matrix()} and \code{is.mQR_matrix()} are functions to test whether an object is a quality report or a list of quality reports.
}
\details{
A\code{\link{QR_matrix}} object is a list of three items:
\itemize{
\item \code{modalities}, a \code{data.frame} containing a set of categorical variables (by default: Good, Uncertain, Bad, Severe).
\item \code{values}, a \code{data.frame} containing the values corresponding to the \code{modalities} indicators (i.e. p-values, statistics, etc.),
as well as variables for which a modality cannot be defined (e.g. the series frequency, the ARIMA model, etc).
\item \code{score_formula} contains the formula used to calculate the series score (once the calculus is done).
}
}
\seealso{
\link[=fr-QR_matrix]{Traduction française}
}
